/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationProvider;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.services.EMFPatternLanguageGrammarAccess;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.AbstractEMFPatternLanguageProposalProvider;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.ClassifierPrefixMatcher;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.EnumPrefixMatcher;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.PatternImporter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IAggregatorFactory;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.ui.contentassist.XbaseProposalProvider;

public class EMFPatternLanguageProposalProvider
extends AbstractEMFPatternLanguageProposalProvider {
    private static final Set<String> FILTERED_KEYWORDS = Sets.newHashSet((Object[])new String[]{"pattern"});
    @Inject
    private PatternAnnotationProvider annotationProvider;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    AbstractJavaBasedContentProposalProvider.ReferenceProposalCreator crossReferenceProposalCreator;
    @Inject
    IQualifiedNameConverter nameConverter;
    @Inject
    private EMFPatternLanguageGrammarAccess ga;
    @Inject
    private XbaseProposalProvider.ValidFeatureDescription featureDescriptionPredicate;
    @Inject
    private IJvmTypeProvider.Factory jvmTypeProviderFactory;
    @Inject
    private ITypesProposalProvider typeProposalProvider;

    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (context.getCurrentNode().getGrammarElement() == this.ga.getML_COMMENTRule() || context.getCurrentNode().getGrammarElement() == this.ga.getSL_COMMENTRule()) {
            return;
        }
        super.createProposals(context, acceptor);
    }

    private ICompletionProposal configurePatternProposal(ICompletionProposal original) {
        if (original instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal prop = (ConfigurableCompletionProposal)original;
            prop.setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)new PatternImporter());
        }
        return original;
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        Function factory = super.getProposalFactory(ruleName, contentAssistContext);
        if (contentAssistContext.getCurrentNode().getSemanticElement() instanceof PatternCall && this.ga.getQualifiedNameRule().getName().equals(ruleName)) {
            factory = Functions.compose(this::configurePatternProposal, (Function)factory);
        }
        return factory;
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (FILTERED_KEYWORDS.contains(keyword.getValue())) {
            return;
        }
        super.completeKeyword(keyword, contentAssistContext, acceptor);
    }

    @Override
    public void complete_ValueReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ValueReference(model, ruleCall, context, acceptor);
        if (model instanceof PathExpressionConstraint) {
            PathExpressionConstraint head = (PathExpressionConstraint)model;
            PatternLanguageHelper.getPathExpressionEMFTailType((PathExpressionConstraint)head).filter(EEnum.class::isInstance).map(EEnum.class::cast).ifPresent(type -> {
                ContentAssistContext.Builder myContextBuilder = context.copy();
                myContextBuilder.setMatcher((PrefixMatcher)new EnumPrefixMatcher(type.getName()));
                for (EEnumLiteral literal : type.getELiterals()) {
                    ICompletionProposal completionProposal = this.createCompletionProposal("::" + literal.getName(), String.valueOf(type.getName()) + "::" + literal.getName(), null, myContextBuilder.toContext());
                    acceptor.accept(completionProposal);
                }
            });
            PatternBody body = (PatternBody)head.eContainer();
            for (Variable var : body.getVariables()) {
                acceptor.accept(this.createCompletionProposal(var.getName(), context));
            }
            Pattern pattern = (Pattern)body.eContainer();
            for (Variable var : pattern.getParameters()) {
                acceptor.accept(this.createCompletionProposal(var.getName(), context));
            }
        }
    }

    @Override
    public void complete_PackageImport(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PatternModel pModel = null;
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (root instanceof PatternModel) {
            pModel = (PatternModel)root;
        }
        ContentAssistContext.Builder myContextBuilder = context.copy();
        myContextBuilder.setMatcher((PrefixMatcher)new ClassifierPrefixMatcher(context.getMatcher(), this.getQualifiedNameConverter()));
        ClassType type = null;
        if (!(model instanceof Variable)) {
            return;
        }
        type = (ClassType)((Variable)model).getType();
        ICompositeNode node = NodeModelUtils.getNode((EObject)type);
        int offset = node.getOffset();
        Region replaceRegion = new Region(offset, context.getReplaceRegion().getLength() + context.getReplaceRegion().getOffset() - offset);
        myContextBuilder.setReplaceRegion(replaceRegion);
        myContextBuilder.setLastCompleteNode((INode)node);
        StringBuilder availablePrefix = new StringBuilder(4);
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (leaf.getGrammarElement() != null && !leaf.isHidden()) {
                if (leaf.getTotalLength() + leaf.getTotalOffset() < context.getOffset()) {
                    availablePrefix.append(leaf.getText());
                } else {
                    availablePrefix.append(leaf.getText().substring(0, context.getOffset() - leaf.getTotalOffset()));
                }
            }
            if (leaf.getTotalOffset() < context.getOffset()) continue;
        }
        myContextBuilder.setPrefix(availablePrefix.toString());
        ContentAssistContext myContext = myContextBuilder.toContext();
        for (PackageImport declaration : PatternLanguageHelper.getPackageImportsIterable((PatternModel)pModel)) {
            if (declaration.getEPackage() == null) continue;
            this.createClassifierProposals(declaration, model, myContext, acceptor);
        }
    }

    private void createClassifierProposals(PackageImport declaration, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean createDatatypeProposals = this.modelOrContainerIs(model, Variable.class);
        boolean createEnumProposals = this.modelOrContainerIs(model, EnumRule.class);
        boolean createClassProposals = this.modelOrContainerIs(model, Variable.class);
        Function<IEObjectDescription, ICompletionProposal> factory = this.getProposalFactory(null, context);
        for (EClassifier classifier : declaration.getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EDataType && createDatatypeProposals || classifier instanceof EEnum && createEnumProposals) && (!(classifier instanceof EClass) || !createClassProposals)) continue;
            String classifierName = this.getValueConverter().toString((Object)classifier.getName(), "ID");
            QualifiedName proposalQualifiedName = QualifiedName.create((String)classifierName);
            IEObjectDescription description = EObjectDescription.create((QualifiedName)proposalQualifiedName, (EObject)classifier);
            ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
            if (proposal != null) {
                proposal.setPriority(proposal.getPriority() * 2);
            }
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    private boolean modelOrContainerIs(EObject model, Class<?> ... types) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(model) || type.isInstance(model.eContainer())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void complete_RefType(PathExpressionConstraint model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject reference = NodeModelUtils.findActualSemanticObjectFor((INode)context.getCurrentNode());
        int index = model.getEdgeTypes().indexOf((Object)reference);
        int edgeCount = model.getEdgeTypes().size();
        if (Objects.equals(model, reference) && edgeCount > 1) {
            index = edgeCount;
        }
        IScope scope = this.scopeProvider.getScope((EObject)(index > 0 ? (EObject)model.getEdgeTypes().get(index - 1) : model.getSourceType()), PatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME);
        this.crossReferenceProposalCreator.lookupCrossReference(scope, (EObject)model, PatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME, acceptor, Predicates.alwaysTrue(), this.getProposalFactory(ruleCall.getRule().getName(), context));
    }

    @Override
    public void completePackageImport_EPackage(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completePackageImport_EPackage(model, assignment, context, (ICompletionProposalAcceptor)new StringProposalDelegate(acceptor, context));
    }

    private boolean isReferrable(Variable v) {
        return v != null && !v.eIsProxy() && !v.getName().startsWith("_") && !PatternLanguageHelper.hasAggregateReference((Variable)v);
    }

    private boolean isReferrable(IEObjectDescription desc) {
        if (desc != null && EcoreUtil2.isAssignableFrom((EClass)PatternLanguagePackage.Literals.VARIABLE, (EClass)desc.getEClass())) {
            Variable v = (Variable)desc.getEObjectOrProxy();
            return v != null && !v.eIsProxy() && !v.getName().startsWith("_") && !PatternLanguageHelper.hasAggregateReference((Variable)v);
        }
        return false;
    }

    @Override
    public void complete_Annotation(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (String annotationName : this.annotationProvider.getAllAnnotationNames()) {
            ICompletionProposal proposal;
            if (this.annotationProvider.isDeprecated(annotationName)) continue;
            String prefixedName = String.format("@%s", annotationName);
            String prefix = context.getPrefix();
            ContentAssistContext modifiedContext = context;
            INode lastNode = context.getLastCompleteNode();
            if ("".equals(prefix) && lastNode.getSemanticElement() instanceof Annotation) {
                Annotation previousNode = (Annotation)lastNode.getSemanticElement();
                String annotationPrefix = previousNode.getName();
                if (previousNode.getParameters().isEmpty() && !this.annotationProvider.getAllAnnotationNames().contains(annotationPrefix)) {
                    modifiedContext = context.copy().setReplaceRegion(new Region(lastNode.getOffset(), lastNode.getLength() + prefix.length())).toContext();
                    prefixedName = annotationName;
                }
            }
            if ((proposal = this.createCompletionProposal(prefixedName, prefixedName, null, modifiedContext)) instanceof ConfigurableCompletionProposal) {
                ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)this.annotationProvider.getAnnotationObject(annotationName));
                ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
            }
            acceptor.accept(proposal);
        }
    }

    @Override
    public void complete_AnnotationParameter(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof Annotation) {
            Annotation annotation = (Annotation)model;
            for (String paramName : this.annotationProvider.getAnnotationParameters(annotation.getName())) {
                String outputName = String.format("%s = ", paramName);
                ICompletionProposal proposal = this.createCompletionProposal(outputName, paramName, null, context);
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)this.annotationProvider.getAnnotationParameter(annotation.getName(), paramName));
                    ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
                }
                acceptor.accept(proposal);
            }
        }
    }

    @Override
    public void complete_VariableReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.scopeProvider.getScope(model, PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VARIABLE);
        this.crossReferenceProposalCreator.lookupCrossReference(scope, model, PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VARIABLE, acceptor, this::isReferrable, this.getProposalFactory(ruleCall.getRule().getName(), context));
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, IExpressionScope.Anchor anchor, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        String prefix = contentAssistContext.getPrefix();
        if (prefix.length() > 0 && !Character.isJavaIdentifierStart(prefix.charAt(0))) {
            return;
        }
        PatternBody body = (PatternBody)EcoreUtil2.getContainerOfType((EObject)context, PatternBody.class);
        for (Variable v : Iterables.filter((Iterable)body.getVariables(), this::isReferrable)) {
            ICompletionProposal proposal = this.createCompletionProposal(v.getName(), contentAssistContext);
            acceptor.accept(proposal);
        }
        this.proposeDeclaringTypeForStaticInvocation(context, null, contentAssistContext, acceptor);
    }

    @Override
    public void completePatternCall_PatternRef(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, Predicates.and((Predicate)this.featureDescriptionPredicate, input -> !"true".equals(input.getUserData("private"))));
    }

    @Override
    public void completeAggregatedValue_Aggregator(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IJvmTypeProvider jvmTypeProvider = this.jvmTypeProviderFactory.createTypeProvider(model.eResource().getResourceSet());
        JvmType interfaceToImplement = jvmTypeProvider.findTypeByName(IAggregatorFactory.class.getName());
        this.typeProposalProvider.createSubTypeProposals(interfaceToImplement, (ICompletionProposalFactory)this, context, PatternLanguagePackage.Literals.AGGREGATED_VALUE__AGGREGATOR, TypeMatchFilters.canInstantiate(), acceptor);
    }

    static class StringProposalDelegate
    extends ICompletionProposalAcceptor.Delegate {
        ContentAssistContext ctx;

        StringProposalDelegate(ICompletionProposalAcceptor delegate, ContentAssistContext ctx) {
            super(delegate);
            this.ctx = ctx;
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal prop = (ConfigurableCompletionProposal)proposal;
                int replacementLength = prop.getReplacementLength();
                int endPos = prop.getReplacementOffset() + replacementLength;
                IXtextDocument document = this.ctx.getDocument();
                if (document != null && document.getLength() > endPos) {
                    try {
                        if ("\"".equals(document.get(endPos, 1))) {
                            String replacementString = prop.getReplacementString();
                            prop.setReplacementString(replacementString.substring(0, replacementString.length() - 1));
                        }
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException("No content at position inside the document", e);
                    }
                }
            }
            super.accept(proposal);
        }
    }
}

