/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class TmfAbstractToolTipHandler {
    private static final int OFFSET = 16;
    private Composite fTipComposite;
    private Shell fTipShell;

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TmfAbstractToolTipHandler.this.fTipShell != null && !TmfAbstractToolTipHandler.this.fTipShell.isDisposed()) {
                    TmfAbstractToolTipHandler.this.fTipShell.dispose();
                }
            }
        });
        control.addMouseMoveListener(e -> {
            if (this.fTipShell != null && !this.fTipShell.isDisposed()) {
                this.fTipShell.dispose();
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                Point pt = control.toDisplay(e.x, e.y);
                if (TmfAbstractToolTipHandler.this.fTipShell != null && !TmfAbstractToolTipHandler.this.fTipShell.isDisposed() && !TmfAbstractToolTipHandler.this.fTipShell.getBounds().contains(pt)) {
                    TmfAbstractToolTipHandler.this.fTipShell.dispose();
                }
            }

            public void mouseHover(MouseEvent event) {
                if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                Control timeGraphControl = (Control)event.widget;
                TmfAbstractToolTipHandler.this.createTooltipShell(timeGraphControl.getShell());
                Control[] controlArray = TmfAbstractToolTipHandler.this.fTipComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                TmfAbstractToolTipHandler.this.fill(control, event, pt);
                if (TmfAbstractToolTipHandler.this.fTipComposite.getChildren().length == 0) {
                    return;
                }
                TmfAbstractToolTipHandler.this.fTipShell.pack();
                Point tipPosition = control.toDisplay(pt);
                TmfAbstractToolTipHandler.setHoverLocation(TmfAbstractToolTipHandler.this.fTipShell, tipPosition);
                TmfAbstractToolTipHandler.this.fTipShell.setVisible(true);
            }
        });
    }

    private void createTooltipShell(Shell parent) {
        Display display = parent.getDisplay();
        if (this.fTipShell != null && !this.fTipShell.isDisposed()) {
            this.fTipShell.dispose();
        }
        this.fTipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.fTipShell.setLayout((Layout)gridLayout);
        this.fTipShell.setBackground(display.getSystemColor(29));
        this.fTipComposite = new Composite((Composite)this.fTipShell, 0);
        this.fTipComposite.setLayout((Layout)new GridLayout(3, false));
        this.setupControl((Control)this.fTipComposite);
    }

    private static void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = position.x + shellBounds.width + 16 > displayBounds.width && position.x - shellBounds.width - 16 >= 0 ? position.x - shellBounds.width - 16 : Math.max(Math.min(position.x + 16, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = position.y + shellBounds.height + 16 > displayBounds.height && position.y - shellBounds.height - 16 >= 0 ? position.y - shellBounds.height - 16 : Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }

    private void setupControl(Control control) {
        control.setForeground(this.fTipShell.getDisplay().getSystemColor(28));
        control.setBackground(this.fTipShell.getDisplay().getSystemColor(29));
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TmfAbstractToolTipHandler.this.fTipShell.dispose();
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                TmfAbstractToolTipHandler.this.fTipShell.dispose();
            }
        });
        control.addMouseMoveListener(e -> this.fTipShell.dispose());
    }

    protected Composite getTipComposite() {
        return this.fTipComposite;
    }

    protected void addItem(String name, String value) {
        Label nameLabel = new Label(this.fTipComposite, 524288);
        nameLabel.setText(name);
        this.setupControl((Control)nameLabel);
        Label separator = new Label(this.fTipComposite, 524802);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.heightHint = nameLabel.computeSize((int)-1, (int)-1).y;
        separator.setLayoutData((Object)gd);
        this.setupControl((Control)separator);
        Label valueLabel = new Label(this.fTipComposite, 524288);
        valueLabel.setText(value);
        this.setupControl((Control)valueLabel);
    }

    protected abstract void fill(Control var1, MouseEvent var2, Point var3);
}

