/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.perspectives;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class TmfPerspectiveManager {
    private static TmfPerspectiveManager fInstance;
    private boolean fPrompting;

    public TmfPerspectiveManager() {
        TmfSignalManager.register((Object)this);
    }

    public static synchronized void init() {
        if (fInstance == null) {
            fInstance = new TmfPerspectiveManager();
        }
    }

    public static synchronized void dispose() {
        if (fInstance != null) {
            TmfSignalManager.deregister((Object)fInstance);
            fInstance = null;
        }
    }

    @TmfSignalHandler
    public synchronized void traceOpened(TmfTraceOpenedSignal signal) {
        Display.getDefault().asyncExec(() -> {
            String id = null;
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)signal.getTrace())) {
                String perspectiveId = TmfTraceTypeUIUtils.getPerspectiveId(trace);
                if (id != null && !id.equals(perspectiveId)) {
                    return;
                }
                id = perspectiveId;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (id != null && window != null && this.shouldSwitchPerspective(window, id, "SWITCH_TO_PERSPECTIVE")) {
                this.switchToPerspective(window, id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSwitchPerspective(IWorkbenchWindow window, String perspectiveId, String preferenceKey) {
        String perspectiveName;
        if (TmfPerspectiveManager.isCurrentPerspective(window, perspectiveId)) {
            return false;
        }
        IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        String string = perspectiveName = perspective == null ? null : perspective.getLabel();
        if (perspectiveName == null) {
            return false;
        }
        String switchPerspective = Activator.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("always".equals(switchPerspective)) {
            return true;
        }
        if ("never".equals(switchPerspective)) {
            return false;
        }
        Shell shell = window.getShell();
        if (shell == null || this.fPrompting) {
            return false;
        }
        this.fPrompting = true;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.TmfPerspectiveManager_SwitchPerspectiveDialogTitle, (String)MessageFormat.format(Messages.TmfPerspectiveManager_SwitchPerspectiveDialogMessage, perspectiveName), null, (boolean)false, (IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)preferenceKey);
        boolean answer = dialog.getReturnCode() == 2;
        TmfPerspectiveManager tmfPerspectiveManager = this;
        synchronized (tmfPerspectiveManager) {
            this.fPrompting = false;
            this.notifyAll();
        }
        if (TmfPerspectiveManager.isCurrentPerspective(window, perspectiveId)) {
            answer = false;
        }
        return answer;
    }

    private static boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    protected void switchToPerspective(IWorkbenchWindow window, String id) {
        try {
            window.getWorkbench().showPerspective(id, window);
        }
        catch (WorkbenchException e) {
            TraceUtils.displayErrorMsg(Messages.TmfPerspectiveManager_SwitchPerspectiveErrorTitle, Messages.TmfPerspectiveManager_SwitchPerspectiveErrorMessage, e);
        }
    }
}

