/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateChangeCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenEventHandler;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlEventHandlerCu
implements IDataDrivenCompilationUnit {
    private final List<TmfXmlStateChangeCu> fStateChanges;
    private final String fEventName;

    TmfXmlEventHandlerCu(String eventName, List<TmfXmlStateChangeCu> stateChanges) {
        this.fStateChanges = stateChanges;
        this.fEventName = eventName;
    }

    @Override
    public DataDrivenEventHandler generate() {
        List<DataDrivenAction> collect = this.fStateChanges.stream().map(TmfXmlStateChangeCu::generate).collect(Collectors.toList());
        return new DataDrivenEventHandler(this.fEventName, collect);
    }

    public static @Nullable TmfXmlEventHandlerCu compile(AnalysisCompilationData analysisData, Element eventHandler) {
        String eventName = eventHandler.getAttribute("eventName");
        ArrayList<TmfXmlStateChangeCu> stateChanges = new ArrayList<TmfXmlStateChangeCu>();
        List<@NonNull Element> childElements = TmfXmlUtils.getChildElements(eventHandler, "stateChange");
        for (Element childElem : childElements) {
            TmfXmlStateChangeCu compile = TmfXmlStateChangeCu.compile(analysisData, childElem);
            if (compile == null) {
                return null;
            }
            stateChanges.add(compile);
        }
        return new TmfXmlEventHandlerCu(eventName, stateChanges);
    }
}

