/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4;

import com.google.common.collect.ImmutableMap;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Endpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.tcp.TCPPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.IPProtocolNumberHelper;

public class IPv4Packet
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final int fVersion;
    private final int fInternetHeaderLength;
    private final int fDSCP;
    private final int fExplicitCongestionNotification;
    private final int fTotalLength;
    private final int fIdentification;
    private final boolean fReservedFlag;
    private final boolean fDontFragmentFlag;
    private final boolean fMoreFragmentFlag;
    private final int fFragmentOffset;
    private final int fTimeToLive;
    private final int fIpDatagramProtocol;
    private final int fHeaderChecksum;
    private final Inet4Address fSourceIpAddress;
    private final Inet4Address fDestinationIpAddress;
    private final byte @Nullable [] fOptions;
    private @Nullable IPv4Endpoint fSourceEndpoint = null;
    private @Nullable IPv4Endpoint fDestinationEndpoint = null;
    private @Nullable Map<String, String> fFields = null;

    public IPv4Packet(PcapFile file, @Nullable Packet parent, ByteBuffer packet) throws BadPacketException {
        super(file, parent, PcapProtocol.IPV4);
        packet.order(ByteOrder.BIG_ENDIAN);
        packet.position(0);
        byte storage = packet.get();
        this.fVersion = (storage & 0xF0) >> 4 & 0xFF;
        this.fInternetHeaderLength = storage & 0xF;
        storage = packet.get();
        this.fDSCP = (storage & 0xFC) >> 2 & 0xFF;
        this.fExplicitCongestionNotification = storage & 3;
        this.fTotalLength = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fIdentification = ConversionHelper.unsignedShortToInt(packet.getShort());
        storage = packet.get();
        this.fReservedFlag = IPv4Packet.isBitSet(storage, 7);
        this.fDontFragmentFlag = IPv4Packet.isBitSet(storage, 6);
        this.fMoreFragmentFlag = IPv4Packet.isBitSet(storage, 5);
        int msb = (storage & 0x1F) << 8;
        int lsb = ConversionHelper.unsignedByteToInt(packet.get());
        this.fFragmentOffset = msb + lsb;
        this.fTimeToLive = ConversionHelper.unsignedByteToInt(packet.get());
        this.fIpDatagramProtocol = ConversionHelper.unsignedByteToInt(packet.get());
        this.fHeaderChecksum = ConversionHelper.unsignedShortToInt(packet.getShort());
        byte[] source = new byte[4];
        byte[] destination = new byte[4];
        packet.get(source);
        packet.get(destination);
        try {
            this.fSourceIpAddress = (Inet4Address)NonNullUtils.checkNotNull((Object)InetAddress.getByAddress(source));
            this.fDestinationIpAddress = (Inet4Address)NonNullUtils.checkNotNull((Object)InetAddress.getByAddress(destination));
        }
        catch (UnknownHostException e) {
            throw new BadPacketException("The IP Address size is not valid!");
        }
        if (this.fInternetHeaderLength > 5) {
            this.fOptions = new byte[(this.fInternetHeaderLength - 5) * 4];
            packet.get(this.fOptions);
        } else {
            this.fOptions = null;
        }
        if (packet.array().length - packet.position() > 0) {
            byte[] array = new byte[packet.array().length - packet.position()];
            packet.get(array);
            ByteBuffer payload = ByteBuffer.wrap(array);
            payload.order(ByteOrder.BIG_ENDIAN);
            payload.position(0);
            this.fPayload = payload;
        } else {
            this.fPayload = null;
        }
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        switch (this.fIpDatagramProtocol) {
            case 6: {
                return new TCPPacket(this.getPcapFile(), (Packet)this, payload);
            }
            case 17: {
                return new UDPPacket(this.getPcapFile(), (Packet)this, payload);
            }
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    public String toString() {
        String flagString = null;
        if (this.fReservedFlag && this.fDontFragmentFlag && this.fMoreFragmentFlag) {
            flagString = "Flags: 0x07 (Invalid)";
        } else if (this.fReservedFlag && this.fDontFragmentFlag && !this.fMoreFragmentFlag) {
            flagString = "Flags: 0x06 (Invalid)";
        } else if (this.fReservedFlag && !this.fDontFragmentFlag && this.fMoreFragmentFlag) {
            flagString = "Flags: 0x05 (Invalid)";
        } else if (this.fReservedFlag && !this.fDontFragmentFlag && !this.fMoreFragmentFlag) {
            flagString = "Flags: 0x04 (Invalid)";
        } else if (!this.fReservedFlag && this.fDontFragmentFlag && this.fMoreFragmentFlag) {
            flagString = "Flags: 0x03 (Invalid)";
        } else if (!this.fReservedFlag && this.fDontFragmentFlag && !this.fMoreFragmentFlag) {
            flagString = "Flags: 0x02 (Don't fragment)";
        } else if (!this.fReservedFlag && !this.fDontFragmentFlag && this.fMoreFragmentFlag) {
            flagString = "Flags: 0x01 (More fragments)";
        } else if (!(this.fReservedFlag || this.fDontFragmentFlag || this.fMoreFragmentFlag)) {
            flagString = "Flags: 0x00 (Don't have more fragments)";
        }
        flagString = String.valueOf(flagString) + ", Fragment Offset: " + this.fFragmentOffset;
        String checksumString = "Header Checksum: " + String.format("%s%04x", "0x", this.fHeaderChecksum);
        String string = String.valueOf(this.getProtocol().getName()) + ", Source: " + this.fSourceIpAddress.getHostAddress() + ", Destination: " + this.fDestinationIpAddress.getHostAddress() + "\nVersion: " + this.fVersion + ", Identification: " + String.format("%s%04x", "0x", this.fIdentification) + ", Header Length: " + this.getHeaderLength() + " bytes, Total Length: " + this.getTotalLength() + " bytes\nDifferentiated Services Code Point: " + String.format("%s%02x", "0x", this.fDSCP) + "; Explicit Congestion Notification: " + String.format("%s%02x", "0x", this.fExplicitCongestionNotification) + "\n" + flagString + "\nTime to live: " + this.fTimeToLive + "\nProtocol: " + this.fIpDatagramProtocol + "\n" + checksumString + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public int getHeaderLength() {
        return this.fInternetHeaderLength * 4;
    }

    public int getDSCP() {
        return this.fDSCP;
    }

    public int getExplicitCongestionNotification() {
        return this.fExplicitCongestionNotification;
    }

    public int getTotalLength() {
        return this.fTotalLength;
    }

    public int getIdentification() {
        return this.fIdentification;
    }

    public boolean getReservedFlag() {
        return this.fReservedFlag;
    }

    public boolean getDontFragmentFlag() {
        return this.fDontFragmentFlag;
    }

    public boolean getHasMoreFragment() {
        return this.fMoreFragmentFlag;
    }

    public int getFragmentOffset() {
        return this.fFragmentOffset;
    }

    public int getTimeToLive() {
        return this.fTimeToLive;
    }

    public int getIpDatagramProtocol() {
        return this.fIpDatagramProtocol;
    }

    public int getHeaderChecksum() {
        return this.fHeaderChecksum;
    }

    public Inet4Address getSourceIpAddress() {
        return this.fSourceIpAddress;
    }

    public Inet4Address getDestinationIpAddress() {
        return this.fDestinationIpAddress;
    }

    public byte @Nullable [] getOptions() {
        byte[] options = this.fOptions;
        if (options == null) {
            return null;
        }
        return Arrays.copyOf(options, options.length);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public IPv4Endpoint getSourceEndpoint() {
        @Nullable IPv4Endpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new IPv4Endpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public IPv4Endpoint getDestinationEndpoint() {
        @Nullable IPv4Endpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new IPv4Endpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull @NonNull ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"Version", (Object)String.valueOf(this.fVersion)).put((Object)"Header Length", (Object)(String.valueOf(String.valueOf(this.getHeaderLength())) + " bytes")).put((Object)"Differentiated Services Field", (Object)String.format("%s%02x", "0x", this.fDSCP)).put((Object)"Explicit Congestion Notification", (Object)String.format("%s%02x", "0x", this.fExplicitCongestionNotification)).put((Object)"Total Length", (Object)(String.valueOf(String.valueOf(this.fTotalLength)) + " bytes")).put((Object)"Identification", (Object)String.format("%s%04x", "0x", this.fIdentification)).put((Object)"Don't Fragment Flag", (Object)String.valueOf(this.fDontFragmentFlag)).put((Object)"More Fragment Flag", (Object)String.valueOf(this.fMoreFragmentFlag)).put((Object)"Fragment Offset", (Object)String.valueOf(this.fFragmentOffset)).put((Object)"Time to live", (Object)String.valueOf(this.fTimeToLive)).put((Object)"Protocol", (Object)(String.valueOf(IPProtocolNumberHelper.toString(this.fIpDatagramProtocol)) + " (" + String.valueOf(this.fIpDatagramProtocol) + ")")).put((Object)"Checksum", (Object)String.format("%s%04x", "0x", this.fHeaderChecksum)).put((Object)"Source IP Address", (Object)NonNullUtils.nullToEmptyString((Object)this.fSourceIpAddress.getHostAddress())).put((Object)"Destination IP Address", (Object)NonNullUtils.nullToEmptyString((Object)this.fDestinationIpAddress.getHostAddress()));
            byte[] options = this.fOptions;
            if (options == null) {
                builder.put((Object)"Options", (Object)"");
            } else {
                builder.put((Object)"Options", (Object)ConversionHelper.bytesToHex(options, true));
            }
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Src: " + this.fSourceIpAddress.getHostAddress() + " , Dst: " + this.fDestinationIpAddress.getHostAddress();
    }

    @Override
    protected String getSignificationString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fSourceIpAddress.getHostAddress()).append(" > ").append(this.fDestinationIpAddress.getHostAddress());
        String flags = this.generateFlagString();
        if (!flags.equals("")) {
            sb.append(' ').append('[').append(flags).append(']');
        }
        sb.append(" Id=").append(this.fIdentification);
        ByteBuffer payload = this.fPayload;
        if (payload != null) {
            sb.append(" Len=").append(payload.array().length);
        } else {
            sb.append(" Len=0");
        }
        return NonNullUtils.nullToEmptyString((Object)sb);
    }

    private String generateFlagString() {
        StringBuilder sb = new StringBuilder();
        boolean start = true;
        if (this.fDontFragmentFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("DF");
            start = false;
        }
        if (this.fMoreFragmentFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("MF");
            start = false;
        }
        return NonNullUtils.nullToEmptyString((Object)sb);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        Packet child = this.fChildPacket;
        result = child != null ? 31 * result + child.hashCode() : (result *= 31);
        result = 31 * result + this.fDSCP;
        result = 31 * result + this.fDestinationIpAddress.hashCode();
        result = 31 * result + (this.fDontFragmentFlag ? 1231 : 1237);
        result = 31 * result + this.fExplicitCongestionNotification;
        result = 31 * result + this.fFragmentOffset;
        result = 31 * result + this.fHeaderChecksum;
        result = 31 * result + this.fIdentification;
        result = 31 * result + this.fInternetHeaderLength;
        result = 31 * result + this.fIpDatagramProtocol;
        result = 31 * result + (this.fMoreFragmentFlag ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.fOptions);
        ByteBuffer payload = this.fPayload;
        result = payload != null ? 31 * result + payload.hashCode() : (result *= 31);
        result = 31 * result + (this.fReservedFlag ? 1231 : 1237);
        result = 31 * result + this.fSourceIpAddress.hashCode();
        result = 31 * result + this.fTimeToLive;
        result = 31 * result + this.fTotalLength;
        result = 31 * result + this.fVersion;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4Packet other = (IPv4Packet)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (this.fDSCP != other.fDSCP) {
            return false;
        }
        if (!this.fDestinationIpAddress.equals(other.fDestinationIpAddress)) {
            return false;
        }
        if (this.fDontFragmentFlag != other.fDontFragmentFlag) {
            return false;
        }
        if (this.fExplicitCongestionNotification != other.fExplicitCongestionNotification) {
            return false;
        }
        if (this.fFragmentOffset != other.fFragmentOffset) {
            return false;
        }
        if (this.fHeaderChecksum != other.fHeaderChecksum) {
            return false;
        }
        if (this.fIdentification != other.fIdentification) {
            return false;
        }
        if (this.fInternetHeaderLength != other.fInternetHeaderLength) {
            return false;
        }
        if (this.fIpDatagramProtocol != other.fIpDatagramProtocol) {
            return false;
        }
        if (this.fMoreFragmentFlag != other.fMoreFragmentFlag) {
            return false;
        }
        if (!Arrays.equals(this.fOptions, other.fOptions)) {
            return false;
        }
        if (!Objects.equals(this.fPayload, other.fPayload)) {
            return false;
        }
        if (this.fReservedFlag != other.fReservedFlag) {
            return false;
        }
        if (!this.fSourceIpAddress.equals(other.fSourceIpAddress)) {
            return false;
        }
        if (this.fTimeToLive != other.fTimeToLive) {
            return false;
        }
        if (this.fTotalLength != other.fTotalLength) {
            return false;
        }
        return this.fVersion == other.fVersion;
    }
}

