/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views;

import java.util.BitSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.UIDebugManager;
import org.eclipse.ptp.internal.debug.ui.actions.RegisterAction;
import org.eclipse.ptp.internal.debug.ui.actions.ResumeAction;
import org.eclipse.ptp.internal.debug.ui.actions.StepIntoAction;
import org.eclipse.ptp.internal.debug.ui.actions.StepOverAction;
import org.eclipse.ptp.internal.debug.ui.actions.StepReturnAction;
import org.eclipse.ptp.internal.debug.ui.actions.SuspendAction;
import org.eclipse.ptp.internal.debug.ui.actions.TerminateAction;
import org.eclipse.ptp.internal.debug.ui.actions.UnregisterAction;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.debug.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.internal.debug.ui.views.ParallelDebugViewEventHandler;
import org.eclipse.ptp.internal.ui.IJobManager;
import org.eclipse.ptp.internal.ui.actions.ParallelAction;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.IToolTipProvider;
import org.eclipse.ptp.internal.ui.views.ParallelJobsView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class ParallelDebugView
extends ParallelJobsView {
    protected ParallelAction resumeAction = null;
    protected ParallelAction suspendAction = null;
    protected ParallelAction terminateAction = null;
    protected ParallelAction stepIntoAction = null;
    protected ParallelAction stepOverAction = null;
    protected ParallelAction stepReturnAction = null;
    protected ParallelAction registerAction = null;
    protected ParallelAction unregisterAction = null;
    protected AbstractPDebugViewEventHandler fEventHandler = null;
    protected Viewer launchViewer = null;
    protected ISelectionChangedListener debugViewSelectChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPDebugElement && ParallelDebugView.this.canvas != null && !ParallelDebugView.this.canvas.isDisposed() && ParallelDebugView.this.getCurrentSet() != null) {
                int index = ((IPDebugElement)element).getID();
                if (!ParallelDebugView.this.getCurrentSet().contains(index)) {
                    ParallelDebugView.this.canvas.unselectAllElements();
                    ParallelDebugView.this.canvas.selectElement(index);
                    ParallelDebugView.this.canvas.setCurrentSelection(false);
                    ParallelDebugView.this.refresh(false);
                }
            }
        }
    };

    public ParallelDebugView() {
        super((IJobManager)PTPDebugUIPlugin.getUIDebugManager());
    }

    public void dispose() {
        if (this.launchViewer != null) {
            this.launchViewer.removeSelectionChangedListener(this.debugViewSelectChangedListener);
        }
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
        super.dispose();
    }

    protected Viewer getDebugViewer() {
        IViewPart part;
        IWorkbenchPage page;
        if (this.launchViewer == null && (page = this.getViewSite().getPage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) != null && part instanceof AbstractDebugView) {
            this.launchViewer = ((AbstractDebugView)part).getViewer();
            if (this.launchViewer != null) {
                this.launchViewer.addSelectionChangedListener(this.debugViewSelectChangedListener);
            }
        }
        return this.launchViewer;
    }

    protected void setEventHandler(AbstractPDebugViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected AbstractPDebugViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    public void createView(Composite parent) {
        super.createView(parent);
        this.setEventHandler(new ParallelDebugViewEventHandler(this));
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("threadGroup"));
        manager.add((IContributionItem)new Separator("stepGroup"));
        manager.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        manager.add((IContributionItem)new GroupMarker("stepOverGroup"));
        manager.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        manager.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        manager.add((IContributionItem)new Separator("regGroup"));
        manager.appendToGroup("threadGroup", (IAction)this.resumeAction);
        manager.appendToGroup("threadGroup", (IAction)this.suspendAction);
        manager.appendToGroup("threadGroup", (IAction)this.terminateAction);
        manager.appendToGroup("stepIntoGroup", (IAction)this.stepIntoAction);
        manager.appendToGroup("stepOverGroup", (IAction)this.stepOverAction);
        manager.appendToGroup("emptyStepGroup", (IAction)this.stepReturnAction);
    }

    protected void createToolBarActionGroup(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IContributionItem)new Separator("threadGroup"));
        toolBarMgr.add((IContributionItem)new Separator("stepGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepOverGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        toolBarMgr.add((IContributionItem)new Separator("regGroup"));
        super.createToolBarActionGroup(toolBarMgr);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.resumeAction = new ResumeAction(this);
        this.suspendAction = new SuspendAction(this);
        this.terminateAction = new TerminateAction(this);
        this.stepIntoAction = new StepIntoAction(this);
        this.stepOverAction = new StepOverAction(this);
        this.stepReturnAction = new StepReturnAction(this);
        this.registerAction = new RegisterAction(this);
        this.unregisterAction = new UnregisterAction(this);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.resumeAction);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.suspendAction);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.terminateAction);
        toolBarMgr.appendToGroup("stepIntoGroup", (IAction)this.stepIntoAction);
        toolBarMgr.appendToGroup("stepOverGroup", (IAction)this.stepOverAction);
        toolBarMgr.appendToGroup("stepReturnGroup", (IAction)this.stepReturnAction);
        toolBarMgr.appendToGroup("regGroup", (IAction)this.registerAction);
        toolBarMgr.appendToGroup("regGroup", (IAction)this.unregisterAction);
        super.buildInToolBarActions(toolBarMgr);
    }

    protected void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
    }

    public void doubleClick(int index) {
        try {
            this.registerElement(index);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.errorDialog(this.getViewSite().getShell(), Messages.ParallelDebugView_0, e.getStatus());
        }
    }

    public String[] getToolTipText(int element) {
        String[] header = super.getToolTipText(element);
        String variableText = ((UIDebugManager)this.manager).getValueText(element, (IToolTipProvider)this);
        if (variableText != null && variableText.length() > 0) {
            return new String[]{header[0], variableText};
        }
        return header;
    }

    public void registerElement(int element) throws CoreException {
        BitSet set = new BitSet();
        set.set(element);
        if (this.getCurrentElementHandler().isRegistered(element)) {
            ((UIDebugManager)this.manager).unregisterElements(set);
        } else {
            ((UIDebugManager)this.manager).registerElements(set);
        }
    }

    public void registerSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).registerElements(this.canvas.getSelectedElements());
        }
    }

    public void unregisterSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).unregisterElements(this.canvas.getSelectedElements());
        }
    }

    public void updateAction() {
        super.updateAction();
        IJobStatus job = ((UIDebugManager)this.manager).findJobById(this.getCurrentID());
        boolean isDebugMode = ((UIDebugManager)this.manager).isDebugMode(job);
        boolean isRunning = ((UIDebugManager)this.manager).isRunning(job);
        this.registerAction.setEnabled(isRunning && isDebugMode);
        this.unregisterAction.setEnabled(isRunning && isDebugMode);
        this.suspendAction.setEnabled(isRunning && isDebugMode);
        this.terminateAction.setEnabled(isRunning);
        if (isRunning && isDebugMode) {
            IElementHandler elementHandler = this.getCurrentElementHandler();
            if (elementHandler != null) {
                this.updateDebugButtons(this.getCurrentID());
            }
        } else {
            this.resumeAction.setEnabled(false);
            this.stepIntoAction.setEnabled(false);
            this.stepOverAction.setEnabled(false);
            this.stepReturnAction.setEnabled(false);
            this.suspendAction.setEnabled(false);
        }
    }

    private void updateDebugButtons(String jobId) {
        IPSession session = ((UIDebugManager)this.manager).getDebugSession(jobId);
        if (session == null) {
            return;
        }
        IElementSet set = this.getCurrentSet();
        if (set == null) {
            return;
        }
        TaskSet terminatedTasks = session.getPDISession().getTaskManager().getTerminatedTasks();
        TaskSet suspendedTasks = session.getPDISession().getTaskManager().getSuspendedTasks();
        TaskSet stepReturnTasks = session.getPDISession().getTaskManager().getCanStepReturnTasks();
        if (terminatedTasks == null || suspendedTasks == null || stepReturnTasks == null) {
            return;
        }
        int setSize = set.size();
        int totalTerminatedSize = 0;
        int totalSuspendedSize = 0;
        int totalStepReturnSize = 0;
        if (set.isRootSet()) {
            totalTerminatedSize = terminatedTasks.cardinality();
            totalSuspendedSize = suspendedTasks.isEmpty() ? 0 : suspendedTasks.cardinality();
            totalStepReturnSize = stepReturnTasks.isEmpty() ? 0 : stepReturnTasks.cardinality();
        } else {
            try {
                TaskSet setTerminatedTasks;
                TaskSet setTasks = ((UIDebugManager)this.manager).getTasks(set.getID());
                if (setTasks == null) {
                    return;
                }
                setSize = setTasks.cardinality();
                if (setSize != (totalTerminatedSize = (setTerminatedTasks = session.getPDISession().getTaskManager().getTerminatedTasks(setTasks.copy())).cardinality())) {
                    TaskSet setSuspendedTasks = session.getPDISession().getTaskManager().getSuspendedTasks(setTasks.copy());
                    totalSuspendedSize = setSuspendedTasks.cardinality();
                    TaskSet setCanStepReturnTasks = session.getPDISession().getTaskManager().getCanStepReturnTasks(setTasks.copy());
                    totalStepReturnSize = setCanStepReturnTasks.cardinality();
                }
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
        boolean enabledTerminatedButton = setSize != totalTerminatedSize;
        this.terminateAction.setEnabled(enabledTerminatedButton);
        if (enabledTerminatedButton) {
            this.resumeAction.setEnabled(totalSuspendedSize > 0);
            boolean enableStepButtons = setSize == totalSuspendedSize + totalTerminatedSize;
            this.stepIntoAction.setEnabled(enableStepButtons);
            this.stepOverAction.setEnabled(enableStepButtons);
            this.suspendAction.setEnabled(!enableStepButtons);
            this.stepReturnAction.setEnabled(enableStepButtons && totalStepReturnSize > 0);
        } else {
            this.resumeAction.setEnabled(false);
            this.stepIntoAction.setEnabled(false);
            this.stepOverAction.setEnabled(false);
            this.stepReturnAction.setEnabled(false);
            this.suspendAction.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structSelection;
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structSelection = (IStructuredSelection)selection).size() == 1 && structSelection.getFirstElement() instanceof BitSet) {
            BitSet set = (BitSet)structSelection.getFirstElement();
            IJobStatus job = this.getJobManager().getJob();
            int element = set.nextSetBit(0);
            if (job != null && element >= 0 && this.getCurrentElementHandler().isRegistered(element)) {
                try {
                    this.focusOnDebugTarget(job.getJobId(), element);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private IDebugElement getDebugElement(String jobId, int task_id) {
        IPSession session = ((UIDebugManager)this.manager).getDebugSession(jobId);
        if (session != null) {
            return session.getLaunch().getDebugTarget(task_id);
        }
        return null;
    }

    public void focusOnDebugTarget(final String jobId, final int task_id) {
        WorkbenchJob wjob = new WorkbenchJob(Messages.ParallelDebugView_3){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ISelection selection;
                Viewer viewer = ParallelDebugView.this.getDebugViewer();
                if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IPDebugElement) {
                        if (((IPDebugElement)element).getID() != task_id) {
                            IDebugElement focusElement = ParallelDebugView.this.getDebugElement(jobId, task_id);
                            if (focusElement == null) {
                                return Status.CANCEL_STATUS;
                            }
                            ParallelDebugView.this.selectOnViewer(viewer, focusElement);
                            element = focusElement;
                        }
                    } else {
                        IDebugElement focusElement = ParallelDebugView.this.getDebugElement(jobId, task_id);
                        if (focusElement == null) {
                            return Status.CANCEL_STATUS;
                        }
                        ParallelDebugView.this.selectOnViewer(viewer, focusElement);
                        element = focusElement;
                    }
                    if (element instanceof IStackFrame) {
                        return Status.CANCEL_STATUS;
                    }
                    if (element instanceof IThread) {
                        ParallelDebugView.this.expandOnViewer(viewer, (IDebugElement)((IThread)element));
                        return Status.OK_STATUS;
                    }
                    if (element instanceof IDebugTarget) {
                        ParallelDebugView.this.expandOnViewer(viewer, (IDebugElement)((IDebugTarget)element));
                        return Status.OK_STATUS;
                    }
                }
                return Status.CANCEL_STATUS;
            }
        };
        wjob.setPriority(50);
        wjob.schedule(500L);
    }

    private void expandOnViewer(final Viewer viewer, final IDebugElement element) {
        WorkbenchJob wjob = new WorkbenchJob(Messages.ParallelDebugView_4){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ((TreeViewer)viewer).setExpandedState((Object)element, true);
                try {
                    if (element instanceof IThread) {
                        ParallelDebugView.this.selectOnViewer(viewer, (IDebugElement)((IThread)element).getTopStackFrame());
                        return Status.OK_STATUS;
                    }
                    if (element instanceof IDebugTarget) {
                        IThread[] threads = ((IPDebugTarget)element).getThreads();
                        if (threads.length > 0) {
                            ParallelDebugView.this.expandOnViewer(viewer, (IDebugElement)threads[0]);
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (DebugException e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        wjob.setPriority(50);
        wjob.schedule();
    }

    private void selectOnViewer(final Viewer viewer, final IDebugElement element) {
        if (element != null) {
            WorkbenchJob wjob = new WorkbenchJob(Messages.ParallelDebugView_5){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (viewer instanceof InternalTreeModelViewer) {
                        ((InternalTreeModelViewer)viewer).setSelection((ISelection)new StructuredSelection((Object)element), true, true);
                    } else {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                    }
                    return Status.OK_STATUS;
                }
            };
            wjob.setPriority(50);
            wjob.schedule();
        }
    }

    public void changeJobRefresh(IJobStatus job, boolean force) {
        IPSession session;
        if (job != null && job.getState().equals("COMPLETED") && (session = ((UIDebugManager)this.manager).getDebugSession(job.getJobId())) != null) {
            TaskSet tasks = session.getTasks();
            if (!session.getPDISession().getTaskManager().isAllTerminated(tasks)) {
                session.forceStoppedDebugger(true);
            }
        }
        super.changeJobRefresh(job, force);
    }
}

