/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.compiler.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.compiler.ast.visitor.TraitUseStatementVisitor;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.TraitAliasObject;
import org.eclipse.php.internal.core.typeinference.TraitPrecedenceObject;
import org.eclipse.php.internal.core.typeinference.UseTrait;

public class TraitUtils {
    public static UseTrait parse(IType type) {
        final UseTrait useTrait = new UseTrait();
        final ISourceModule sourceModule = type.getSourceModule();
        try {
            final ISourceRange sourceRange = type.getSourceRange();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            moduleDeclaration.traverse((ASTVisitor)new TraitUseStatementVisitor(){

                @Override
                public boolean visit(TraitUseStatement s) throws Exception {
                    if (s.sourceStart() > sourceRange.getOffset() && s.sourceEnd() < sourceRange.getOffset() + sourceRange.getLength()) {
                        TraitUtils.parse(sourceModule, sourceRange.getOffset(), s, useTrait);
                    }
                    return false;
                }
            });
        }
        catch (ModelException modelException) {
        }
        catch (Exception exception) {}
        return useTrait;
    }

    public static UseTrait parse(ISourceModule sourceModule, int offset, TraitUseStatement statement, UseTrait useTrait) {
        if (useTrait == null) {
            useTrait = new UseTrait();
        }
        for (TypeReference typeReference : statement.getTraitList()) {
            FullyQualifiedReference reference;
            String name = typeReference.getName();
            if (typeReference instanceof FullyQualifiedReference && (reference = (FullyQualifiedReference)typeReference).getNamespace() != null) {
                name = String.valueOf(reference.getNamespace().getName()) + '\\' + name;
            }
            useTrait.getTraits().add(PHPModelUtils.getFullName(name, sourceModule, offset));
        }
        for (TraitStatement traitStatement : statement.getTsList()) {
            TraitStatement new_name;
            if (traitStatement instanceof TraitAliasStatement) {
                List<TraitAliasObject> traitAliases;
                TraitAliasObject ta;
                Object simpleReference;
                new_name = (TraitAliasStatement)traitStatement;
                Expression traitMethod = ((TraitAliasStatement)new_name).getAlias().getTraitMethod();
                if (traitMethod instanceof SimpleReference) {
                    simpleReference = (SimpleReference)traitMethod;
                    ta = new TraitAliasObject();
                    ta.traitMethodName = simpleReference.getName();
                    ta.newMethodVisibility = ((TraitAliasStatement)new_name).getAlias().getModifier();
                    if (((TraitAliasStatement)new_name).getAlias().getMethodName() != null) {
                        ta.newMethodName = ((TraitAliasStatement)new_name).getAlias().getMethodName().getName();
                    }
                    useTrait.getTraitAliases().add(ta);
                    traitAliases = useTrait.getAliasMap().get(ta.traitMethodName);
                    if (traitAliases == null) {
                        traitAliases = new ArrayList<TraitAliasObject>();
                        useTrait.getAliasMap().put(ta.traitMethodName, traitAliases);
                    }
                    traitAliases.add(ta);
                    continue;
                }
                if (!(traitMethod instanceof FullyQualifiedTraitMethodReference)) continue;
                simpleReference = (FullyQualifiedTraitMethodReference)traitMethod;
                ta = new TraitAliasObject();
                ta.traitName = PHPModelUtils.getFullName(((FullyQualifiedTraitMethodReference)((Object)simpleReference)).getClassName().getName(), sourceModule, offset);
                ta.traitMethodName = ((FullyQualifiedTraitMethodReference)((Object)simpleReference)).getFunctionName();
                ta.newMethodVisibility = ((TraitAliasStatement)new_name).getAlias().getModifier();
                if (((TraitAliasStatement)new_name).getAlias().getMethodName() != null) {
                    ta.newMethodName = ((TraitAliasStatement)new_name).getAlias().getMethodName().getName();
                }
                useTrait.getTraitAliases().add(ta);
                traitAliases = useTrait.getAliasMap().get(ta.traitMethodName);
                if (traitAliases == null) {
                    traitAliases = new ArrayList<TraitAliasObject>();
                    useTrait.getAliasMap().put(ta.traitMethodName, traitAliases);
                }
                traitAliases.add(ta);
                continue;
            }
            if (!(traitStatement instanceof TraitPrecedenceStatement)) continue;
            new_name = (TraitPrecedenceStatement)traitStatement;
            TraitPrecedenceObject tpo = new TraitPrecedenceObject();
            tpo.traitName = PHPModelUtils.getFullName(((TraitPrecedenceStatement)new_name).getPrecedence().getMethodReference().getClassName().getName(), sourceModule, offset);
            tpo.traitMethodName = ((TraitPrecedenceStatement)new_name).getPrecedence().getMethodReference().getFunctionName();
            for (TypeReference typeReference : ((TraitPrecedenceStatement)new_name).getPrecedence().getTrList()) {
                tpo.insteadofTraitNameList.add(typeReference.getName());
            }
            useTrait.getPrecedenceMap().put(tpo.traitMethodName, tpo);
        }
        return useTrait;
    }

    public static IField[] getTraitFields(IType type, Set<String> nameSet) {
        UseTrait useTrait = TraitUtils.parse(type);
        ArrayList<IField> fieldList = new ArrayList<IField>();
        HashSet<String> traitNameSet = new HashSet<String>();
        for (String trait : useTrait.getTraits()) {
            IType[] traitTypes;
            IType[] iTypeArray = traitTypes = PHPModelAccess.getDefault().findTraits(trait, ISearchEngine.MatchRule.EXACT, 0, 0, TraitUtils.createSearchScope(type), null);
            int n = traitTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType traitType = iTypeArray[n2];
                String traitName = PHPModelUtils.getFullName(traitType);
                if (trait.equals(traitName) && !traitNameSet.contains(traitName)) {
                    traitNameSet.add(traitName);
                    try {
                        IField[] fields;
                        IField[] iFieldArray = fields = PHPModelUtils.getTypeField(traitType, "", false);
                        int n3 = fields.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IField field = iFieldArray[n4];
                            List<IField> aliasList = TraitUtils.getFieldWrapper(useTrait, field, type);
                            for (IField alias : aliasList) {
                                if (alias == null) continue;
                                String elementName = alias.getElementName();
                                if (elementName.startsWith("$")) {
                                    elementName = elementName.substring(1);
                                }
                                if (nameSet.contains(elementName)) continue;
                                fieldList.add(alias);
                            }
                            ++n4;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                ++n2;
            }
        }
        return fieldList.toArray(new IField[fieldList.size()]);
    }

    private static List<IField> getFieldWrapper(UseTrait useTrait, IField field, IType type) {
        ArrayList<IField> result = new ArrayList<IField>();
        String fieldName = field.getElementName();
        if (fieldName.startsWith("$")) {
            fieldName = fieldName.substring(1);
        }
        TraitPrecedenceObject tpo = useTrait.getPrecedenceMap().get(fieldName);
        boolean shouldAddSelf = true;
        boolean changeVisibility = false;
        if (tpo != null) {
            shouldAddSelf = false;
        }
        List<TraitAliasObject> aliasList = useTrait.getAliasMap().get(fieldName);
        String fullName = PHPModelUtils.getFullName(field.getDeclaringType());
        if (aliasList != null) {
            for (TraitAliasObject tao : aliasList) {
                if (tao.traitName == null || fullName.equals(tao.traitName)) {
                    FieldWrapper alias = new FieldWrapper((IMember)field, tao.newMethodVisibility, tao.newMethodName, type);
                    result.add((IField)alias);
                    if (fieldName.equals(tao.newMethodName) || tao.newMethodName == null) {
                        changeVisibility = true;
                    }
                }
                if (tpo == null || !fullName.equals(tpo.traitName)) continue;
                shouldAddSelf = true;
            }
        } else if (tpo != null && fullName.equals(tpo.traitName)) {
            shouldAddSelf = true;
        }
        if (shouldAddSelf && !changeVisibility) {
            result.add(field);
        }
        return result;
    }

    public static IMethod[] getTraitMethods(IType type, Set<String> nameSet) {
        UseTrait useTrait = TraitUtils.parse(type);
        ArrayList<IMethod> fieldList = new ArrayList<IMethod>();
        HashSet<String> traitNameSet = new HashSet<String>();
        for (String trait : useTrait.getTraits()) {
            IType[] traitTypes;
            IType[] iTypeArray = traitTypes = PHPModelAccess.getDefault().findTraits(trait, ISearchEngine.MatchRule.EXACT, 0, 0, TraitUtils.createSearchScope(type), null);
            int n = traitTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType traitType = iTypeArray[n2];
                String traitName = PHPModelUtils.getFullName(traitType);
                if (trait.equals(traitName) && !traitNameSet.contains(traitName)) {
                    traitNameSet.add(traitName);
                    try {
                        IMethod[] methods;
                        IMethod[] iMethodArray = methods = PHPModelUtils.getTypeMethod(traitType, "", false);
                        int n3 = methods.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMethod method = iMethodArray[n4];
                            List<IMethod> aliasList = TraitUtils.getMethodWrapper(useTrait, method, type);
                            for (IMethod alias : aliasList) {
                                String elementName;
                                if (alias == null || nameSet.contains(elementName = alias.getElementName())) continue;
                                fieldList.add(alias);
                            }
                            ++n4;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                ++n2;
            }
        }
        return fieldList.toArray(new IMethod[fieldList.size()]);
    }

    private static List<IMethod> getMethodWrapper(UseTrait useTrait, IMethod method, IType type) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        String methodName = method.getElementName();
        TraitPrecedenceObject tpo = useTrait.getPrecedenceMap().get(methodName);
        boolean shouldAddSelf = true;
        boolean changeVisibility = false;
        if (tpo != null) {
            shouldAddSelf = false;
        }
        List<TraitAliasObject> aliasList = useTrait.getAliasMap().get(methodName);
        String fullName = PHPModelUtils.getFullName(method.getDeclaringType());
        if (aliasList != null) {
            for (TraitAliasObject tao : aliasList) {
                if (tao.traitName == null || fullName.equals(tao.traitName)) {
                    MethodWrapper alias = new MethodWrapper(method, tao.newMethodVisibility, tao.newMethodName, type);
                    result.add((IMethod)alias);
                    if (methodName.equals(tao.newMethodName) || tao.newMethodName == null) {
                        changeVisibility = true;
                    }
                }
                if (tpo == null || !fullName.equals(tpo.traitName)) continue;
                shouldAddSelf = true;
            }
        } else if (tpo != null && fullName.equals(tpo.traitName)) {
            shouldAddSelf = true;
        }
        if (shouldAddSelf && !changeVisibility) {
            result.add(method);
        }
        return result;
    }

    public static IDLTKSearchScope createSearchScope(IType type) {
        ISourceModule sourceModule = type.getSourceModule();
        IScriptProject scriptProject = sourceModule.getScriptProject();
        if (scriptProject != null) {
            return SearchEngine.createSearchScope((IModelElement)scriptProject);
        }
        IProjectFragment projectFragment = (IProjectFragment)sourceModule.getAncestor(3);
        if (projectFragment != null) {
            return SearchEngine.createSearchScope((IModelElement)projectFragment);
        }
        return SearchEngine.createSearchScope((IModelElement)sourceModule);
    }

    private static class FieldWrapper
    extends SourceField
    implements ITraitMember {
        private int flags = -1;
        private String name;
        private IMember member;
        private IType type;

        public FieldWrapper(IMember member, int flags, String name, IType type) {
            super((ModelElement)member.getParent(), member.getElementName());
            this.member = member;
            if (!name.startsWith("$")) {
                name = "$" + name;
            }
            this.name = name;
            this.type = type;
            try {
                this.flags = member.getFlags();
                if (flags != -1) {
                    if (PHPFlags.isPrivate((int)this.flags)) {
                        this.flags ^= 0x10;
                    } else if (PHPFlags.isProtected((int)this.flags)) {
                        this.flags ^= 0x20;
                    } else if (PHPFlags.isPublic((int)this.flags)) {
                        this.flags ^= 0x40;
                    }
                    this.flags |= flags;
                }
            }
            catch (ModelException modelException) {}
        }

        public int getFlags() throws ModelException {
            if (this.flags != -1) {
                return this.flags;
            }
            return this.member.getFlags();
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.member.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.member.getSourceRange();
        }

        public String getElementName() {
            if (this.name != null) {
                return this.name;
            }
            return this.member.getElementName();
        }

        @Override
        public String getRealName() {
            return this.member.getElementName();
        }

        @Override
        public IType getHostType() {
            return this.type;
        }

        @Override
        public boolean useAlias() {
            return this.name != null && !this.name.equals(this.member.getElementName());
        }
    }

    public static interface ITraitMember {
        public String getRealName();

        public IType getHostType();

        public boolean useAlias();
    }

    private static class MethodWrapper
    extends SourceMethod
    implements ITraitMember {
        private int flags = -1;
        private String name;
        private IMethod member;
        private IType type;

        public MethodWrapper(IMethod member, int flags, String name, IType type) {
            super((ModelElement)member.getParent(), member.getElementName());
            this.member = member;
            this.name = name;
            this.type = type;
            try {
                this.flags = member.getFlags();
                if (flags != -1) {
                    if (PHPFlags.isPrivate((int)this.flags)) {
                        this.flags ^= 0x10;
                    } else if (PHPFlags.isProtected((int)this.flags)) {
                        this.flags ^= 0x20;
                    } else if (PHPFlags.isPublic((int)this.flags)) {
                        this.flags ^= 0x40;
                    }
                    this.flags |= flags;
                }
            }
            catch (ModelException modelException) {}
        }

        public int getFlags() throws ModelException {
            if (this.flags != -1) {
                return this.flags;
            }
            return this.member.getFlags();
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.member.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.member.getSourceRange();
        }

        public String getElementName() {
            if (this.name != null) {
                return this.name;
            }
            return this.member.getElementName();
        }

        @Override
        public String getRealName() {
            return this.member.getElementName();
        }

        @Override
        public IType getHostType() {
            return this.type;
        }

        public IParameter[] getParameters() throws ModelException {
            return this.member.getParameters();
        }

        public String[] getParameterNames() throws ModelException {
            return this.member.getParameterNames();
        }

        public boolean isConstructor() throws ModelException {
            return false;
        }

        @Override
        public boolean useAlias() {
            return this.name != null && !this.name.equals(this.member.getElementName());
        }
    }
}

