/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.TypesStrategy;

public class UseNameStrategy
extends TypesStrategy {
    public UseNameStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    public UseNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        this.reportKeyword("const", reporter);
        this.reportKeyword("function", reporter);
        super.apply(reporter);
    }

    private void reportKeyword(String keyword, ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext completionContext = (AbstractCompletionContext)this.getContext();
        if (completionContext instanceof UseStatementContext) {
            UseStatementContext context = (UseStatementContext)completionContext;
            if (context.isUseFunctionStatement() || context.isUseConstStatement() || context.getType() == UseStatementContext.TYPES.TRAIT) {
                return;
            }
            if (keyword.startsWith(context.getPrefixBeforeCursor())) {
                reporter.reportKeyword(keyword, this.getSuffix(context), this.getReplacementRange(context));
            }
        } else if (keyword.startsWith(completionContext.getPrefix())) {
            reporter.reportKeyword(keyword, this.getSuffix(completionContext), this.getReplacementRange(completionContext));
        }
    }

    @Override
    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        if (!this.isInsertMode()) {
            return this.getReplacementRangeWithSpaceAtPrefixEnd(context);
        }
        return super.getReplacementRange(context);
    }

    @Override
    public ISourceRange getReplacementRangeForMember(AbstractCompletionContext context) throws BadLocationException {
        UseStatementContext useStatementContext = (UseStatementContext)context;
        if (useStatementContext.getGroupPrefixBeforeOpeningCurly() != null) {
            int idx = useStatementContext.getPrefixBeforeCursor().lastIndexOf("\\");
            int move = idx != -1 ? idx + 1 : 0;
            ISourceRange basicRange = this.getReplacementRange(context);
            return new SourceRange(basicRange.getOffset() + move, basicRange.getLength() - move);
        }
        return super.getReplacementRangeForMember(useStatementContext);
    }

    @Override
    public String getSuffix(AbstractCompletionContext abstractContext) {
        return this.isInsertMode() && abstractContext.hasSpaceAtPosition(abstractContext.getOffset()) ? "" : " ";
    }

    @Override
    protected int getExtraInfo() {
        return 522;
    }
}

