/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.TypeId;

public class JavaDependencyVisitor
extends DependencyVisitor {
    protected final @NonNull JavaGlobalContext<@NonNull ?> globalContext;
    protected final JavaLocalContext<@NonNull ?> localContext;

    public JavaDependencyVisitor(@NonNull CodeGenAnalyzer analyzer, @NonNull JavaGlobalContext<@NonNull ?> globalContext, @NonNull GlobalPlace globalPlace) {
        super(analyzer, globalPlace);
        this.globalContext = globalContext;
        this.localContext = null;
    }

    @Override
    public @Nullable Object visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        TypeId typeId = cgBoxExp.getSource().getASTypeId();
        if (typeId != null) {
            this.addDependency(cgBoxExp, ((CodeGenAnalyzer)this.context).getElementId((ElementId)typeId));
            typeId.accept((IdVisitor)this.id2DependencyVisitor);
        }
        return super.visitCGBoxExp(cgBoxExp);
    }

    @Override
    public @Nullable Object visitCGEcoreExp(@NonNull CGEcoreExp cgEcoreExp) {
        TypeId typeId = cgEcoreExp.getSource().getASTypeId();
        if (typeId != null) {
            this.addDependency(cgEcoreExp, ((CodeGenAnalyzer)this.context).getElementId((ElementId)typeId));
            typeId.accept((IdVisitor)this.id2DependencyVisitor);
        }
        return super.visitCGEcoreExp(cgEcoreExp);
    }

    @Override
    public @Nullable Object visitCGExecutorType(@NonNull CGExecutorType cgTypeWithReflection) {
        return super.visitCGExecutorType(cgTypeWithReflection);
    }

    @Override
    public @Nullable Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        CGValuedElement variableValue = cgTypeExp.getNamedValue();
        variableValue.accept(this);
        this.addDependency(cgTypeExp, variableValue);
        return super.visitCGTypeExp(cgTypeExp);
    }
}

