/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ContainerEnvironmentVariableDialog
extends Dialog {
    private final EnvironmentVariableModel model;
    private final DataBindingContext dbc = new DataBindingContext();

    public ContainerEnvironmentVariableDialog(Shell parentShell) {
        super(parentShell);
        this.model = new EnvironmentVariableModel();
    }

    public ContainerEnvironmentVariableDialog(Shell parentShell, EnvironmentVariableModel selectedVariable) {
        super(parentShell);
        this.model = new EnvironmentVariableModel(selectedVariable);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(WizardMessages.getString("ContainerEnvironmentVariableDialog.title"));
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(WizardMessages.getString("ContainerEnvironmentVariableDialog.explanationLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label variableNameLabel = new Label(container, 0);
        variableNameLabel.setText(WizardMessages.getString("ContainerEnvironmentVariableDialog.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)variableNameLabel);
        Text variableNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)variableNameText);
        Label variableValueLabel = new Label(container, 0);
        variableValueLabel.setText(WizardMessages.getString("ContainerEnvironmentVariableDialog.valueLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)variableValueLabel);
        Text variableValueText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)variableValueText);
        Label errorMessageLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)errorMessageLabel);
        ISWTObservableValue variableNameObservable = WidgetProperties.text((int)24).observe((Widget)variableNameText);
        this.dbc.bindValue((IObservableValue)variableNameObservable, BeanProperties.value(EnvironmentVariableModel.class, (String)"name").observe((Object)this.model));
        ISWTObservableValue variableValueObservable = WidgetProperties.text((int)24).observe((Widget)variableValueText);
        this.dbc.bindValue((IObservableValue)variableValueObservable, BeanProperties.value(EnvironmentVariableModel.class, (String)"value").observe((Object)this.model));
        variableNameObservable.addValueChangeListener(this.onEnvironmentVariableSettingsChanged());
        variableValueObservable.addValueChangeListener(this.onEnvironmentVariableSettingsChanged());
        return container;
    }

    private IValueChangeListener onEnvironmentVariableSettingsChanged() {
        return event -> this.validateInput();
    }

    private void validateInput() {
        String variableName = this.model.getName();
        String variableValue = this.model.getValue();
        if (variableName == null || variableName.isEmpty() || variableValue == null || variableValue.isEmpty()) {
            this.setOkButtonEnabled(false);
        } else {
            this.setOkButtonEnabled(true);
        }
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public EnvironmentVariableModel getEnvironmentVariable() {
        return new EnvironmentVariableModel(this.model.getName(), this.model.getValue());
    }
}

