/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.messages.Container;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.core.DockerPortMapping;

public class DockerContainer
implements IDockerContainer,
IAdaptable {
    private IDockerConnection parent;
    private String id;
    private List<String> names;
    private String image;
    private String command;
    private Long created;
    private String status;
    private List<IDockerPortMapping> ports;
    private Long sizeRw;
    private Long sizeRootFs;
    private IDockerContainerInfo containerInfo;

    public DockerContainer(IDockerConnection connection, Container container) {
        this.parent = connection;
        this.id = container.id();
        this.image = container.image();
        this.command = container.command();
        this.created = container.created();
        this.status = container.status();
        this.names = new ArrayList<String>();
        if (container.names() != null) {
            for (String name : container.names()) {
                if (name.startsWith("/")) {
                    this.names.add(name.substring(1));
                    continue;
                }
                this.names.add(name);
            }
        }
        this.sizeRw = container.sizeRw();
        this.sizeRootFs = container.sizeRootFs();
        this.ports = new ArrayList<IDockerPortMapping>();
        if (container.ports() != null) {
            for (Container.PortMapping port : container.ports()) {
                DockerPortMapping portMapping = new DockerPortMapping(this, port.privatePort(), port.publicPort(), port.type(), port.ip());
                this.ports.add(portMapping);
            }
        }
    }

    public DockerContainer(IDockerConnection connection, Container container, IDockerContainerInfo containerInfo) {
        this(connection, container);
        this.containerInfo = containerInfo;
    }

    @Override
    public IDockerConnection getConnection() {
        return this.parent;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String image() {
        return this.image;
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public Long created() {
        return this.created;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public Long sizeRw() {
        return this.sizeRw;
    }

    @Override
    public Long sizeRootFs() {
        return this.sizeRootFs;
    }

    @Override
    public List<IDockerPortMapping> ports() {
        return this.ports;
    }

    @Override
    public String name() {
        if (this.names != null && this.names.size() > 0) {
            return this.names.get(0);
        }
        return "";
    }

    @Override
    public List<String> names() {
        return this.names;
    }

    @Override
    public IDockerContainerInfo info() {
        return this.info(false);
    }

    public IDockerContainerInfo info(boolean force) {
        if (force || this.isInfoLoaded()) {
            this.containerInfo = this.parent.getContainerInfo(this.id);
        }
        return this.containerInfo;
    }

    public boolean isInfoLoaded() {
        return this.containerInfo != null;
    }

    public String toString() {
        return "Container: id=" + this.id() + "\n" + "  image=" + this.image() + "\n" + "  created=" + this.created() + "\n" + "  command=" + this.command() + "\n" + "  status=<" + this.status() + ">\n" + "  name=" + this.name() + "\n";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerContainer other = (DockerContainer)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IDockerConnection.class)) {
            return (T)this.parent;
        }
        return null;
    }
}

