/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsProvider;
import org.eclipse.linuxtools.internal.docker.core.DefaultUnixConnectionSettingsProvider;
import org.eclipse.linuxtools.internal.docker.core.DockerClientFactory;
import org.eclipse.linuxtools.internal.docker.core.ShellConnectionSettingsProvider;
import org.eclipse.linuxtools.internal.docker.core.SystemConnectionSettingsProvider;

public class DefaultDockerConnectionSettingsFinder
implements IDockerConnectionSettingsFinder {
    public static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String DOCKER_TLS_VERIFY_TRUE = "1";
    public static final String DOCKER_HOST = "DOCKER_HOST";

    @Override
    public IDockerConnectionSettings findDefaultConnectionSettings() {
        IDockerConnectionSettings defaultsWithUnixSocket = this.defaultsWithUnixSocket();
        if (defaultsWithUnixSocket != null) {
            return defaultsWithUnixSocket;
        }
        IDockerConnectionSettings defaultsWithSystemEnv = this.defaultsWithSystemEnv();
        if (defaultsWithSystemEnv != null) {
            return defaultsWithSystemEnv;
        }
        IDockerConnectionSettings defaultsWithShellEnv = this.defaultsWithShellEnv();
        if (defaultsWithShellEnv != null) {
            return defaultsWithShellEnv;
        }
        return null;
    }

    @Override
    public String resolveConnectionName(IDockerConnectionSettings connectionSettings) {
        if (connectionSettings == null) {
            return null;
        }
        try {
            DockerClient client = new DockerClientFactory().getClient(connectionSettings);
            if (client != null) {
                return client.info().name();
            }
        }
        catch (DockerCertificateException | DockerException | InterruptedException throwable) {
            // empty catch block
        }
        return null;
    }

    public IDockerConnectionSettings defaultsWithUnixSocket() {
        List<IDockerConnectionSettings> res = new DefaultUnixConnectionSettingsProvider().getConnectionSettings();
        if (res != null && !res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public IDockerConnectionSettings defaultsWithSystemEnv() {
        List<IDockerConnectionSettings> res = new SystemConnectionSettingsProvider().getConnectionSettings();
        if (res != null && !res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public IDockerConnectionSettings defaultsWithShellEnv() {
        List<IDockerConnectionSettings> res = new ShellConnectionSettingsProvider().getConnectionSettings();
        if (res != null && !res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    @Override
    public List<IDockerConnectionSettings> getKnownConnectionSettings() {
        IConfigurationElement[] configs;
        ArrayList<IDockerConnectionSettings> result = new ArrayList<IDockerConnectionSettings>();
        IConfigurationElement[] iConfigurationElementArray = configs = DefaultDockerConnectionSettingsFinder.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                List<IDockerConnectionSettings> settings;
                Object obj = config.createExecutableExtension("provider");
                if (obj instanceof IDockerConnectionSettingsProvider && (settings = ((IDockerConnectionSettingsProvider)obj).getConnectionSettings()) != null && !settings.isEmpty()) {
                    result.addAll(settings);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }

    private static IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.docker.core.connection");
        return extPoint.getConfigurationElements();
    }

    public static class Defaults {
        public static final String DEFAULT_UNIX_SOCKET_PATH = "unix:///var/run/docker.sock";
        private boolean settingsResolved;
        private String name = null;
        private final Map<EnumDockerConnectionSettings, Object> settings = new HashMap<EnumDockerConnectionSettings, Object>();

        public boolean isSettingsResolved() {
            return this.settingsResolved;
        }

        public String getName() {
            return this.name;
        }

        public EnumDockerConnectionSettings getBindingMode() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.BINDING_MODE)) {
                return (EnumDockerConnectionSettings)((Object)this.settings.get((Object)EnumDockerConnectionSettings.BINDING_MODE));
            }
            return EnumDockerConnectionSettings.UNIX_SOCKET;
        }

        public String getUnixSocketPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.UNIX_SOCKET_PATH);
        }

        public String getTcpHost() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_HOST);
        }

        public boolean getTcpTlsVerify() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY)) {
                return (Boolean)this.settings.get((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY);
            }
            return false;
        }

        public String getTcpCertPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_CERT_PATH);
        }
    }
}

