package org.eclipse.jubula.toolkit.client.api.ui.internal;

import java.util.*;
import java.util.Map.Entry;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.api.ui.utils.OMExport;
import org.eclipse.jubula.tools.internal.constants.StringConstants;

public class OMClassGenerator
{
  protected static String nl;
  public static synchronized OMClassGenerator create(String lineSeparator)
  {
    nl = lineSeparator;
    OMClassGenerator result = new OMClassGenerator();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = NL + "import org.eclipse.jubula.client.MakeR;" + NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + NL + "" + NL + "/** " + NL + " * Exported Object Mapping " + NL + " * @Generated" + NL + " */" + NL + "public class ";
  protected final String TEXT_2 = " {";
  protected final String TEXT_3 = NL + "    /** The component identifier for \"";
  protected final String TEXT_4 = "\"*/" + NL + "    public static final ComponentIdentifier ";
  protected final String TEXT_5 = " = MakeR.createCI(\"";
  protected final String TEXT_6 = "\"); //$NON-NLS-1$";
  protected final String TEXT_7 = NL + "    " + NL + "    /** Constructor */" + NL + "    private ";
  protected final String TEXT_8 = "() {" + NL + "        // private" + NL + "    }" + NL + "}";
  protected final String TEXT_9 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    
OMExport exportedOM = (OMExport) argument;
String className = StringUtils.substringBefore(
                                exportedOM.getTargetClassName(), StringConstants.DOT);

    stringBuffer.append(TEXT_1);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_2);
    
Map<String, String> validJavaIdentifierMapping = exportedOM.createIdentifierMap();
Map<String, String> om = exportedOM.getObjectMapping();
for (Entry<String, String> entry : validJavaIdentifierMapping.entrySet()) {
    String logicalComponentName = entry.getKey();
    String encodedComponentIdentifier = om.get(logicalComponentName);
    String javaQualifier = validJavaIdentifierMapping.get(logicalComponentName);
    stringBuffer.append(TEXT_3);
    stringBuffer.append(logicalComponentName);
    stringBuffer.append(TEXT_4);
    stringBuffer.append(javaQualifier);
    stringBuffer.append(TEXT_5);
    stringBuffer.append(encodedComponentIdentifier);
    stringBuffer.append(TEXT_6);
    }
    stringBuffer.append(TEXT_7);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_8);
    stringBuffer.append(TEXT_9);
    return stringBuffer.toString();
  }
}
