/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import javax.inject.Inject;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StepsToReproduceProcessor implements IReportProcessor {

    private final IProcessorDescriptor descriptor;

    @Inject
    public StepsToReproduceProcessor(IProcessorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    public boolean canContribute(IStatus status, IEclipseContext context) {
        return true;
    }

    @Override
    public void process(IReport report, IStatus status, IEclipseContext context) {
        Shell activeShell = (Shell) context.get(IServiceConstants.ACTIVE_SHELL);
        if (activeShell == null) {
            return;
        }
        Boolean shown = (Boolean) context.get(getContextKey());
        if (shown == null || !shown) {
            MessageDialog.openInformation(activeShell, "Steps to Reproduce",
                    "Please provide detailed steps to reproduce this error into the 'Comment' section. This will help developers fix this problem.");
            context.set(getContextKey(), Boolean.TRUE);
        }
    }

    private String getContextKey() {
        return "processor." + descriptor.getDirective() + ".value";
    }
}
