/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.core.runtime.IStatus;

import org.eclipse.e4.core.contexts.IEclipseContext;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISendOptions;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Log Event</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getServer <em>Server</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup <em>Group</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getInterest <em>Interest</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getOptions <em>Options</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getResponse <em>Response</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getContext <em>Context</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent()
 * @model
 * @generated
 */
public interface ILogEvent extends EObject {
	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Status</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see #setStatus(IStatus)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Status()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IStatus" required="true"
	 * @generated
	 */
	IStatus getStatus();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(IStatus value);

	/**
	 * Returns the value of the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Label</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Label</em>' attribute.
	 * @see #setLabel(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Label()
	 * @model
	 * @generated
	 */
	String getLabel();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getLabel <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Label</em>' attribute.
	 * @see #getLabel()
	 * @generated
	 */
	void setLabel(String value);

	/**
	 * Returns the value of the '<em><b>Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Server</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Server</em>' reference.
	 * @see #setServer(IServerDescriptor)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Server()
	 * @model required="true"
	 * @generated
	 */
	IServerDescriptor getServer();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getServer <em>Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Server</em>' reference.
	 * @see #getServer()
	 * @generated
	 */
	void setServer(IServerDescriptor value);

	/**
	 * Returns the value of the '<em><b>Group</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getEvents <em>Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Group</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Group</em>' container reference.
	 * @see #setGroup(ILogEventGroup)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Group()
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getEvents
	 * @model opposite="events" transient="false"
	 * @generated
	 */
	ILogEventGroup getGroup();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup <em>Group</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Group</em>' container reference.
	 * @see #getGroup()
	 * @generated
	 */
	void setGroup(ILogEventGroup value);

	/**
	 * Returns the value of the '<em><b>Interest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interest</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interest</em>' reference.
	 * @see #setInterest(IProblemState)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Interest()
	 * @model
	 * @generated
	 */
	IProblemState getInterest();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getInterest <em>Interest</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interest</em>' reference.
	 * @see #getInterest()
	 * @generated
	 */
	void setInterest(IProblemState value);

	/**
	 * Returns the value of the '<em><b>Options</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Options</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Options</em>' reference.
	 * @see #setOptions(ISendOptions)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Options()
	 * @model
	 * @generated
	 */
	ISendOptions getOptions();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getOptions <em>Options</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Options</em>' reference.
	 * @see #getOptions()
	 * @generated
	 */
	void setOptions(ISendOptions value);

	/**
	 * Returns the value of the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Response</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Response</em>' reference.
	 * @see #setResponse(IProblemState)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Response()
	 * @model
	 * @generated
	 */
	IProblemState getResponse();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getResponse <em>Response</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Response</em>' reference.
	 * @see #getResponse()
	 * @generated
	 */
	void setResponse(IProblemState value);

	/**
	 * Returns the value of the '<em><b>Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Context</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Context</em>' attribute.
	 * @see #setContext(IEclipseContext)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEvent_Context()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IEclipseContext" required="true"
	 * @generated
	 */
	IEclipseContext getContext();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getContext <em>Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context</em>' attribute.
	 * @see #getContext()
	 * @generated
	 */
	void setContext(IEclipseContext value);

} // ILogEvent
