/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor;

import net.sourceforge.nattable.style.BorderStyle;
import net.sourceforge.nattable.style.editor.AbstractEditorPanel;
import net.sourceforge.nattable.style.editor.BorderThicknessPicker;
import net.sourceforge.nattable.style.editor.ColorPicker;
import net.sourceforge.nattable.style.editor.LineStylePicker;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderStyleEditorPanel
extends AbstractEditorPanel<BorderStyle> {
    private BorderThicknessPicker thicknessPicker;
    private LineStylePicker lineStylePicker;
    private ColorPicker colorPicker;
    private Button noBordersCheckBox;

    @Override
    public String getEditorName() {
        return "Border Style";
    }

    public BorderStyleEditorPanel(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    public void initComponents() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        this.setLayout((Layout)gridLayout);
        new Label((Composite)this, 0).setText("No Border");
        this.noBordersCheckBox = new Button((Composite)this, 32);
        this.noBordersCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean noBorder = BorderStyleEditorPanel.this.noBordersCheckBox.getSelection();
                BorderStyleEditorPanel.this.colorPicker.setEnabled(!noBorder);
                BorderStyleEditorPanel.this.thicknessPicker.setEnabled(!noBorder);
                BorderStyleEditorPanel.this.lineStylePicker.setEnabled(!noBorder);
            }
        });
        new Label((Composite)this, 0).setText("Color");
        this.colorPicker = new ColorPicker(this, GUIHelper.COLOR_WIDGET_BORDER);
        new Label((Composite)this, 0).setText("Line Style");
        this.lineStylePicker = new LineStylePicker(this);
        new Label((Composite)this, 0).setText("Thickness");
        this.thicknessPicker = new BorderThicknessPicker(this);
        this.noBordersCheckBox.setSelection(true);
        this.colorPicker.setEnabled(false);
        this.thicknessPicker.setEnabled(false);
        this.lineStylePicker.setEnabled(false);
    }

    private void disableEditing() {
        this.colorPicker.setEnabled(false);
        this.thicknessPicker.setEnabled(false);
        this.lineStylePicker.setEnabled(false);
    }

    @Override
    public void edit(BorderStyle bstyle) throws Exception {
        if (bstyle != null) {
            this.noBordersCheckBox.setSelection(false);
            this.colorPicker.setSelectedColor(bstyle.getColor());
            this.lineStylePicker.setSelectedLineStyle(bstyle.getLineStyle());
            this.thicknessPicker.setSelectedThickness(bstyle.getThickness());
        } else {
            this.noBordersCheckBox.setSelection(true);
            this.disableEditing();
        }
    }

    @Override
    public BorderStyle getNewValue() {
        if (!this.noBordersCheckBox.getSelection()) {
            Color borderColor = this.colorPicker.getSelectedColor();
            BorderStyle.LineStyleEnum lineStyle = this.lineStylePicker.getSelectedLineStyle();
            int borderThickness = this.thicknessPicker.getSelectedThickness();
            return new BorderStyle(borderThickness, borderColor, lineStyle);
        }
        return null;
    }
}

