/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.data.IRowDataProvider;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.SelectRowsCommand;
import net.sourceforge.nattable.selection.event.ISelectionEvent;
import net.sourceforge.nattable.util.ObjectUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectionProvider<T>
implements ISelectionProvider,
ILayerListener {
    private SelectionLayer selectionLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final boolean fullySelectedRowsOnly;
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();

    public RowSelectionProvider(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        this(selectionLayer, rowDataProvider, true);
    }

    public RowSelectionProvider(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.fullySelectedRowsOnly = fullySelectedRowsOnly;
        selectionLayer.addLayerListener(this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return RowSelectionProvider.populateRowSelection(this.selectionLayer, this.rowDataProvider, this.fullySelectedRowsOnly);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.selectionLayer != null && selection instanceof IStructuredSelection) {
            this.selectionLayer.clear();
            List rowObjects = ((IStructuredSelection)selection).toList();
            HashSet<Integer> rowPositions = new HashSet<Integer>();
            for (Object rowObject : rowObjects) {
                int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
                int rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
                rowPositions.add(rowPosition);
            }
            this.selectionLayer.doCommand(new SelectRowsCommand((ILayer)this.selectionLayer, 0, ObjectUtils.asIntArray(rowPositions), false, true));
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof ISelectionEvent) {
            if (this.fullySelectedRowsOnly && this.selectionLayer.getFullySelectedRowPositions().length == 0) {
                return;
            }
            ISelection selection = this.getSelection();
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
        }
    }

    static StructuredSelection populateRowSelection(SelectionLayer selectionLayer, IRowDataProvider rowDataProvider, boolean fullySelectedRowsOnly) {
        ArrayList<Object> rows;
        block5: {
            rows = new ArrayList<Object>();
            if (selectionLayer == null) break block5;
            if (fullySelectedRowsOnly) {
                int[] nArray = selectionLayer.getFullySelectedRowPositions();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int rowPosition = nArray[n2];
                    RowSelectionProvider.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                    ++n2;
                }
            } else {
                Set<Range> rowRanges = selectionLayer.getSelectedRows();
                for (Range rowRange : rowRanges) {
                    int rowPosition = rowRange.start;
                    while (rowPosition < rowRange.end) {
                        RowSelectionProvider.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                        ++rowPosition;
                    }
                }
            }
        }
        return new StructuredSelection(rows);
    }

    private static void addToSelection(List<Object> rows, int rowPosition, SelectionLayer selectionLayer, IRowDataProvider rowDataProvider) {
        int rowIndex = selectionLayer.getRowIndexByPosition(rowPosition);
        Object rowObject = rowDataProvider.getRowObject(rowIndex);
        rows.add(rowObject);
    }
}

