/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.freeze;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.freeze.FreezeLayer;
import net.sourceforge.nattable.freeze.command.FreezeCommandHandler;
import net.sourceforge.nattable.freeze.config.DefaultFreezeGridBindings;
import net.sourceforge.nattable.grid.layer.DimensionallyDependentLayer;
import net.sourceforge.nattable.layer.CompositeLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.painter.layer.ILayerPainter;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeFreezeLayer
extends CompositeLayer {
    private final FreezeLayer freezeLayer;
    private ILayerPainter layerPainter = new FreezableLayerPainter();

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, true);
    }

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.freezeLayer = freezeLayer;
        this.setChildLayer("FROZEN_REGION", freezeLayer, 0, 0);
        this.setChildLayer("FROZEN_ROW_REGION", new DimensionallyDependentLayer(selectionLayer, viewportLayer, freezeLayer), 1, 0);
        this.setChildLayer("FROZEN_COLUMN_REGION", new DimensionallyDependentLayer(selectionLayer, freezeLayer, viewportLayer), 0, 1);
        this.setChildLayer("NONFROZEN_REGION", viewportLayer, 1, 1);
        this.registerCommandHandler(new FreezeCommandHandler(freezeLayer, viewportLayer, selectionLayer));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultFreezeGridBindings());
        }
    }

    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    class FreezableLayerPainter
    extends CompositeLayer.CompositeLayerPainter {
        FreezableLayerPainter() {
            super(CompositeFreezeLayer.this);
        }

        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
            int freezeHeight;
            super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            gc.setClipping(rectangle);
            Color oldFg = gc.getForeground();
            gc.setForeground(GUIHelper.COLOR_BLUE);
            int freezeWidth = CompositeFreezeLayer.this.freezeLayer.getWidth() - 1;
            if (freezeWidth > 0) {
                gc.drawLine(xOffset + freezeWidth, yOffset, xOffset + freezeWidth, yOffset + CompositeFreezeLayer.this.getHeight() - 1);
            }
            if ((freezeHeight = CompositeFreezeLayer.this.freezeLayer.getHeight() - 1) > 0) {
                gc.drawLine(xOffset, yOffset + freezeHeight, xOffset + CompositeFreezeLayer.this.getWidth() - 1, yOffset + freezeHeight);
            }
            gc.setForeground(oldFg);
        }
    }
}

