/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.action;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.edit.command.EditCellCommand;
import net.sourceforge.nattable.selection.action.CellSelectionDragMode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;

public class CellEditDragMode
extends CellSelectionDragMode {
    private int originalColumnPosition;
    private int originalRowPosition;

    public void mouseDown(NatTable natTable, MouseEvent event) {
        super.mouseDown(natTable, event);
        this.originalColumnPosition = natTable.getColumnPositionByX(event.x);
        this.originalRowPosition = natTable.getRowPositionByY(event.y);
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        super.mouseMove(natTable, event);
        int columnPosition = natTable.getColumnPositionByX(event.x);
        int rowPosition = natTable.getRowPositionByY(event.y);
        if (columnPosition != this.originalColumnPosition || rowPosition != this.originalRowPosition) {
            this.originalColumnPosition = -1;
            this.originalRowPosition = -1;
        }
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        super.mouseUp(natTable, event);
        int columnPosition = natTable.getColumnPositionByX(event.x);
        int rowPosition = natTable.getRowPositionByY(event.y);
        if (columnPosition == this.originalColumnPosition && rowPosition == this.originalRowPosition) {
            natTable.doCommand(new EditCellCommand((Composite)natTable, natTable.getConfigRegistry(), natTable.getCellByPosition(columnPosition, rowPosition)));
        }
    }
}

