/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ActiveCellEditor;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.SingleEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.style.CellStyleProxy;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InlineCellEditController {
    private static Map<ILayer, ILayerListener> layerListenerMap = new HashMap<ILayer, ILayerListener>();

    public static boolean editCellInline(LayerCell cell, Character initialEditValue, Composite parent, IConfigRegistry configRegistry) {
        block7: {
            int rowIndex;
            int rowPosition;
            int columnIndex;
            int columnPosition;
            ILayer layer;
            Rectangle cellBounds;
            List<String> configLabels;
            block6: {
                ActiveCellEditor.commit();
                configLabels = cell.getConfigLabels().getLabels();
                cellBounds = cell.getBounds();
                layer = cell.getLayer();
                columnPosition = layer.getColumnPositionByX(cellBounds.x);
                columnIndex = layer.getColumnIndexByPosition(columnPosition);
                rowPosition = layer.getRowPositionByY(cellBounds.y);
                rowIndex = layer.getRowIndexByPosition(rowPosition);
                boolean editable = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", configLabels).isEditable(columnIndex, rowIndex);
                if (editable) break block6;
                return false;
            }
            try {
                ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", configLabels);
                IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", configLabels);
                CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, "EDIT", configLabels);
                IDataValidator dataValidator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", configLabels);
                SingleEditHandler editHandler = new SingleEditHandler(cellEditor, layer, columnPosition, rowPosition);
                Rectangle editorBounds = layer.getLayerPainter().adjustCellBounds(new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
                Object originalCanonicalValue = cell.getDataValue();
                ActiveCellEditor.activate(cellEditor, parent, originalCanonicalValue, initialEditValue, displayConverter, cellStyle, dataValidator, editHandler, columnPosition, rowPosition, columnIndex, rowIndex);
                Control editorControl = ActiveCellEditor.getControl();
                if (editorControl != null) {
                    editorControl.setBounds(editorBounds);
                    ILayerListener layerListener = layerListenerMap.get(layer);
                    if (layerListener == null) {
                        layerListener = new InlineCellEditLayerListener(layer);
                        layerListenerMap.put(layer, layerListener);
                        layer.addLayerListener(layerListener);
                    }
                }
            }
            catch (Exception e) {
                if (cell == null) {
                    System.err.println("Cell being edited is no longer available. Character: " + initialEditValue);
                    break block7;
                }
                System.err.println("Error while editing cell (inline): Cell: " + cell + "; Character: " + initialEditValue);
                e.printStackTrace(System.err);
            }
        }
        return true;
    }

    public static void dispose() {
        layerListenerMap.clear();
    }

    static class InlineCellEditLayerListener
    implements ILayerListener {
        private final ILayer layer;

        InlineCellEditLayerListener(ILayer layer) {
            this.layer = layer;
        }

        public void handleLayerEvent(ILayerEvent event) {
            if (ActiveCellEditor.isValid()) {
                int editorColumnPosition = ActiveCellEditor.getColumnPosition();
                int editorRowPosition = ActiveCellEditor.getRowPosition();
                int editorColumnIndex = ActiveCellEditor.getColumnIndex();
                int editorRowIndex = ActiveCellEditor.getRowIndex();
                Control editorControl = ActiveCellEditor.getControl();
                int columnIndex = this.layer.getColumnIndexByPosition(editorColumnPosition);
                int rowIndex = this.layer.getRowIndexByPosition(editorRowPosition);
                if (columnIndex != editorColumnIndex || rowIndex != editorRowIndex) {
                    ActiveCellEditor.close();
                } else if (editorControl != null && !editorControl.isDisposed()) {
                    Rectangle cellBounds = this.layer.getBoundsByPosition(editorColumnPosition, editorRowPosition);
                    Rectangle adjustedCellBounds = this.layer.getLayerPainter().adjustCellBounds(cellBounds);
                    editorControl.setBounds(adjustedCellBounds);
                }
            }
        }
    }
}

