/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnChooser.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.nattable.columnChooser.ColumnChooserUtils;
import net.sourceforge.nattable.columnChooser.ColumnEntry;
import net.sourceforge.nattable.columnChooser.ColumnGroupEntry;
import net.sourceforge.nattable.columnChooser.ISelectionTreeListener;
import net.sourceforge.nattable.columnChooser.gui.AbstractColumnChooserDialog;
import net.sourceforge.nattable.coordinate.PositionUtil;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.util.ArrayUtil;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.util.ObjectUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnChooserDialog
extends AbstractColumnChooserDialog {
    private Tree availableTree;
    private Tree selectedTree;
    private final String selectedLabel;
    private final String availableLabel;
    private ColumnGroupModel columnGroupModel;

    public ColumnChooserDialog(Shell parentShell, String availableLabel, String selectedLabel) {
        super(parentShell);
        this.availableLabel = availableLabel;
        this.selectedLabel = selectedLabel;
    }

    @Override
    public void populateDialogArea(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(4, false));
        this.createLabels(parent, this.availableLabel, this.selectedLabel);
        this.availableTree = new Tree(parent, 2835);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, true).create();
        this.availableTree.setLayoutData((Object)gridData);
        this.availableTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColumnChooserDialog.this.addSelected();
            }
        });
        this.availableTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    ColumnChooserDialog.this.addSelected();
                }
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setImage(GUIHelper.getImage("arrow_right"));
        gridData = GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create();
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnChooserDialog.this.addSelected();
            }
        });
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setImage(GUIHelper.getImage("arrow_left"));
        gridData = GridDataFactory.copyData((GridData)gridData);
        removeButton.setLayoutData((Object)gridData);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnChooserDialog.this.removeSelected();
            }
        });
        this.selectedTree = new Tree(parent, 2835);
        gridData = GridDataFactory.fillDefaults().grab(true, true).create();
        this.selectedTree.setLayoutData((Object)gridData);
        this.selectedTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColumnChooserDialog.this.removeSelected();
            }
        });
        this.selectedTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean controlMask;
                boolean bl = controlMask = (e.stateMask & 0x40000) == 262144;
                if (controlMask && e.keyCode == 0x1000001) {
                    ColumnChooserDialog.this.moveSelectedUp();
                    e.doit = false;
                } else if (controlMask && e.keyCode == 0x1000002) {
                    ColumnChooserDialog.this.moveSelectedDown();
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    ColumnChooserDialog.this.removeSelected();
                }
            }
        });
        this.selectedTree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                ColumnChooserDialog.this.selectedTreeCollapsed(event);
            }

            public void treeExpanded(TreeEvent event) {
                ColumnChooserDialog.this.selectedTreeExpanded(event);
            }
        });
        this.selectedTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                ColumnChooserDialog.this.toggleColumnGroupSelection((TreeItem)event.item);
            }
        });
        Composite upDownbuttonComposite = new Composite(parent, 0);
        upDownbuttonComposite.setLayout((Layout)new GridLayout(1, true));
        Button upButton = new Button(upDownbuttonComposite, 8);
        upButton.setImage(GUIHelper.getImage("arrow_up"));
        gridData = GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create();
        upButton.setLayoutData((Object)gridData);
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnChooserDialog.this.moveSelectedUp();
            }
        });
        Button downButton = new Button(upDownbuttonComposite, 8);
        downButton.setImage(GUIHelper.getImage("arrow_down"));
        gridData = GridDataFactory.copyData((GridData)gridData);
        downButton.setLayoutData((Object)gridData);
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnChooserDialog.this.moveSelectedDown();
            }
        });
    }

    protected final void fireItemsSelected(List<ColumnEntry> addedItems) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionTreeListener)listener).itemsSelected(addedItems);
            ++n2;
        }
    }

    protected final void fireItemsRemoved(List<ColumnEntry> removedItems) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionTreeListener)listener).itemsRemoved(removedItems);
            ++n2;
        }
    }

    protected final void fireItemsMoved(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> selectedColumnGroupEntries, List<ColumnEntry> selectedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionTreeListener)listener).itemsMoved(direction, selectedColumnGroupEntries, selectedColumnEntries, fromPositions, toPositions);
            ++n2;
        }
    }

    private void fireGroupExpanded(ColumnGroupEntry columnGroupEntry) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionTreeListener)listener).itemsExpanded(columnGroupEntry);
            ++n2;
        }
    }

    private void fireGroupCollapsed(ColumnGroupEntry columnGroupEntry) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionTreeListener)listener).itemsCollapsed(columnGroupEntry);
            ++n2;
        }
    }

    public void populateSelectedTree(List<ColumnEntry> columnEntries, ColumnGroupModel columnGroupModel) {
        this.populateModel(this.selectedTree, columnEntries, columnGroupModel);
    }

    public void populateAvailableTree(List<ColumnEntry> columnEntries, ColumnGroupModel columnGroupModel) {
        this.populateModel(this.availableTree, columnEntries, columnGroupModel);
    }

    private void populateModel(Tree tree, List<ColumnEntry> columnEntries, ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
        for (ColumnEntry columnEntry : columnEntries) {
            TreeItem treeItem;
            int columnEntryIndex = columnEntry.getIndex();
            if (columnGroupModel != null && columnGroupModel.isPartOfAGroup(columnEntryIndex)) {
                String columnGroupName = columnGroupModel.getColumnGroupNameForIndex(columnEntryIndex);
                TreeItem columnGroupTreeItem = this.getTreeItem(tree, columnGroupName);
                if (columnGroupTreeItem == null) {
                    columnGroupTreeItem = new TreeItem(tree, 0);
                    ColumnGroupEntry columnGroupEntry = new ColumnGroupEntry(columnGroupName, columnEntry.getPosition(), columnEntry.getIndex(), columnGroupModel.isCollapsed(columnEntryIndex));
                    columnGroupTreeItem.setData((Object)columnGroupEntry);
                    columnGroupTreeItem.setText(columnGroupEntry.getLabel());
                }
                treeItem = new TreeItem(columnGroupTreeItem, 0);
            } else {
                treeItem = new TreeItem(tree, 0);
            }
            treeItem.setText(columnEntry.getLabel());
            treeItem.setData((Object)columnEntry);
        }
    }

    private TreeItem getTreeItem(Tree tree, String label) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getText().equals(label)) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    private List<ColumnEntry> getColumnEntriesIncludingNested(TreeItem[] selectedTreeItems) {
        ArrayList<ColumnEntry> selectedColumnEntries = new ArrayList<ColumnEntry>();
        int i = 0;
        while (i < selectedTreeItems.length) {
            if (this.isColumnGroupLeaf(selectedTreeItems[i])) {
                TreeItem[] itemsInGroup;
                TreeItem[] treeItemArray = itemsInGroup = selectedTreeItems[i].getItems();
                int n = itemsInGroup.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem itemInGroup = treeItemArray[n2];
                    selectedColumnEntries.add((ColumnEntry)itemInGroup.getData());
                    ++n2;
                }
            } else {
                selectedColumnEntries.add(this.getColumnEntryInLeaf(selectedTreeItems[i]));
            }
            ++i;
        }
        return selectedColumnEntries;
    }

    private List<ColumnGroupEntry> getSelectedColumnGroupEntries(TreeItem[] selectedTreeItems) {
        ArrayList<ColumnGroupEntry> selectedColumnGroups = new ArrayList<ColumnGroupEntry>();
        int i = 0;
        while (i < selectedTreeItems.length) {
            if (this.isColumnGroupLeaf(selectedTreeItems[i])) {
                selectedColumnGroups.add((ColumnGroupEntry)selectedTreeItems[i].getData());
            }
            ++i;
        }
        return selectedColumnGroups;
    }

    private List<ColumnEntry> getSelectedColumnEntriesIncludingNested(Tree tree) {
        return this.getColumnEntriesIncludingNested(tree.getSelection());
    }

    private List<ColumnGroupEntry> getSelectedColumnGroupEntries(Tree tree) {
        return this.getSelectedColumnGroupEntries(tree.getSelection());
    }

    private void addSelected() {
        if (this.isAnyLeafSelected(this.availableTree)) {
            this.fireItemsSelected(this.getSelectedColumnEntriesIncludingNested(this.availableTree));
        }
    }

    private void removeSelected() {
        if (this.isAnyLeafSelected(this.selectedTree)) {
            this.fireItemsRemoved(this.getSelectedColumnEntriesIncludingNested(this.selectedTree));
        }
    }

    private void selectedTreeCollapsed(TreeEvent event) {
        TreeItem item = (TreeItem)event.item;
        ColumnGroupEntry columnGroupEntry = (ColumnGroupEntry)item.getData();
        this.fireGroupCollapsed(columnGroupEntry);
    }

    private void selectedTreeExpanded(TreeEvent event) {
        TreeItem item = (TreeItem)event.item;
        ColumnGroupEntry columnGroupEntry = (ColumnGroupEntry)item.getData();
        this.fireGroupExpanded(columnGroupEntry);
    }

    private void toggleColumnGroupSelection(TreeItem treeItem) {
        if (this.isColumnGroupLeaf(treeItem)) {
            Collection<TreeItem> selectedLeaves = ArrayUtil.asCollection(this.selectedTree.getSelection());
            boolean selected = selectedLeaves.contains(treeItem);
            if (selected) {
                this.selectAllChildren(this.selectedTree, treeItem);
            } else {
                this.unSelectAllChildren(this.selectedTree, treeItem);
            }
        }
    }

    private void selectAllChildren(Tree tree, TreeItem treeItem) {
        Collection<TreeItem> selectedLeaves = ArrayUtil.asCollection(tree.getSelection());
        if (this.isColumnGroupLeaf(treeItem)) {
            selectedLeaves.addAll(ArrayUtil.asCollection(treeItem.getItems()));
        }
        tree.setSelection(selectedLeaves.toArray(new TreeItem[0]));
        tree.showSelection();
    }

    private void unSelectAllChildren(Tree tree, TreeItem treeItem) {
        Collection<TreeItem> selectedLeaves = ArrayUtil.asCollection(tree.getSelection());
        if (this.isColumnGroupLeaf(treeItem)) {
            selectedLeaves.removeAll(ArrayUtil.asCollection(treeItem.getItems()));
        }
        tree.setSelection(selectedLeaves.toArray(new TreeItem[0]));
        tree.showSelection();
    }

    protected void moveSelectedUp() {
        if (this.isAnyLeafSelected(this.selectedTree) && !this.isFirstLeafSelected(this.selectedTree)) {
            List<ColumnEntry> selectedColumnEntries = this.getSelectedColumnEntriesIncludingNested(this.selectedTree);
            List<ColumnGroupEntry> selectedColumnGroupEntries = this.getSelectedColumnGroupEntries(this.selectedTree);
            List<Integer> allSelectedPositions = this.merge(selectedColumnEntries, selectedColumnGroupEntries);
            List<List<Integer>> postionsGroupedByContiguous = PositionUtil.getGroupedByContiguous(allSelectedPositions);
            ArrayList<Integer> toPositions = new ArrayList<Integer>();
            for (List<Integer> groupedPositions : postionsGroupedByContiguous) {
                boolean columnGroupMoved = this.columnGroupMoved(groupedPositions, selectedColumnGroupEntries);
                int firstPositionInGroup = groupedPositions.get(0);
                if (firstPositionInGroup == 0) {
                    return;
                }
                ColumnEntry columnEntry = this.getColumnEntryForPosition(this.selectedTree, firstPositionInGroup);
                int columnEntryIndex = columnEntry.getIndex();
                ColumnEntry previousColumnEntry = this.getColumnEntryForPosition(this.selectedTree, firstPositionInGroup - 1);
                int previousColumnEntryIndex = previousColumnEntry.getIndex();
                if (columnGroupMoved) {
                    if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAGroup(previousColumnEntryIndex)) {
                        toPositions.add(firstPositionInGroup - this.columnGroupModel.getColumnIndexesInGroup(previousColumnEntryIndex).size());
                        continue;
                    }
                    toPositions.add(firstPositionInGroup - 1);
                    continue;
                }
                if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAnUnbreakableGroup(columnEntryIndex) && !ColumnGroupUtils.isInTheSameGroup(columnEntryIndex, previousColumnEntryIndex, this.columnGroupModel)) {
                    return;
                }
                if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAnUnbreakableGroup(previousColumnEntryIndex) && !ColumnGroupUtils.isInTheSameGroup(columnEntryIndex, previousColumnEntryIndex, this.columnGroupModel)) {
                    toPositions.add(firstPositionInGroup - this.columnGroupModel.getColumnIndexesInGroup(previousColumnEntryIndex).size());
                    continue;
                }
                toPositions.add(firstPositionInGroup - 1);
            }
            this.fireItemsMoved(SelectionLayer.MoveDirectionEnum.UP, selectedColumnGroupEntries, selectedColumnEntries, postionsGroupedByContiguous, toPositions);
        }
    }

    private List<Integer> merge(List<ColumnEntry> selectedColumnEntries, List<ColumnGroupEntry> selectedColumnGroupEntries) {
        List<Integer> columnEntryPositions = ColumnChooserUtils.getColumnEntryPositions(selectedColumnEntries);
        List<Integer> columnGroupEntryPositions = ColumnGroupEntry.getColumnGroupEntryPositions(selectedColumnGroupEntries);
        HashSet<Integer> allSelectedPositionsSet = new HashSet<Integer>();
        allSelectedPositionsSet.addAll(columnEntryPositions);
        allSelectedPositionsSet.addAll(columnGroupEntryPositions);
        ArrayList<Integer> allSelectedPositions = new ArrayList<Integer>(allSelectedPositionsSet);
        Collections.sort(allSelectedPositions);
        return allSelectedPositions;
    }

    protected void moveSelectedDown() {
        if (this.isAnyLeafSelected(this.selectedTree) && !this.isLastLeafSelected(this.selectedTree)) {
            List<ColumnEntry> selectedColumnEntries = this.getSelectedColumnEntriesIncludingNested(this.selectedTree);
            List<ColumnGroupEntry> selectedColumnGroupEntries = this.getSelectedColumnGroupEntries(this.selectedTree);
            List<Integer> allSelectedPositions = this.merge(selectedColumnEntries, selectedColumnGroupEntries);
            List<List<Integer>> postionsGroupedByContiguous = PositionUtil.getGroupedByContiguous(allSelectedPositions);
            ArrayList<Integer> toPositions = new ArrayList<Integer>();
            for (List<Integer> groupedPositions : postionsGroupedByContiguous) {
                boolean columnGroupMoved = this.columnGroupMoved(groupedPositions, selectedColumnGroupEntries);
                int lastListIndex = groupedPositions.size() - 1;
                int lastPositionInGroup = groupedPositions.get(lastListIndex);
                ColumnEntry columnEntry = this.getColumnEntryForPosition(this.selectedTree, lastPositionInGroup);
                int columnEntryIndex = columnEntry.getIndex();
                ColumnEntry nextColumnEntry = this.getColumnEntryForPosition(this.selectedTree, lastPositionInGroup + 1);
                if (nextColumnEntry == null) {
                    return;
                }
                int nextColumnEntryIndex = nextColumnEntry.getIndex();
                if (columnGroupMoved) {
                    if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAGroup(nextColumnEntryIndex)) {
                        toPositions.add(lastPositionInGroup + this.columnGroupModel.getColumnIndexesInGroup(nextColumnEntryIndex).size());
                        continue;
                    }
                    toPositions.add(lastPositionInGroup + 1);
                    continue;
                }
                if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAnUnbreakableGroup(columnEntryIndex) && !ColumnGroupUtils.isInTheSameGroup(columnEntryIndex, nextColumnEntryIndex, this.columnGroupModel)) {
                    return;
                }
                if (this.columnGroupModel != null && this.columnGroupModel.isPartOfAnUnbreakableGroup(nextColumnEntryIndex) && !ColumnGroupUtils.isInTheSameGroup(columnEntryIndex, nextColumnEntryIndex, this.columnGroupModel)) {
                    toPositions.add(lastPositionInGroup + this.columnGroupModel.getColumnIndexesInGroup(nextColumnEntryIndex).size());
                    continue;
                }
                toPositions.add(lastPositionInGroup + 1);
            }
            this.fireItemsMoved(SelectionLayer.MoveDirectionEnum.DOWN, selectedColumnGroupEntries, selectedColumnEntries, postionsGroupedByContiguous, toPositions);
        }
    }

    private boolean columnGroupMoved(List<Integer> fromPositions, List<ColumnGroupEntry> movedColumnGroupEntries) {
        for (ColumnGroupEntry columnGroupEntry : movedColumnGroupEntries) {
            if (!fromPositions.contains(columnGroupEntry.getFirstElementPosition())) continue;
            return true;
        }
        return false;
    }

    private ColumnEntry getColumnEntryForPosition(Tree tree, int columnEntryPosition) {
        List<ColumnEntry> allColumnEntries = this.getColumnEntriesIncludingNested(this.selectedTree.getItems());
        for (ColumnEntry columnEntry : allColumnEntries) {
            if (columnEntry.getPosition() != columnEntryPosition) continue;
            return columnEntry;
        }
        return null;
    }

    protected List<Integer> getIndexesOfSelectedLeaves(Tree tree) {
        List<TreeItem> allSelectedLeaves = ArrayUtil.asList(tree.getSelection());
        ArrayList<Integer> allSelectedIndexes = new ArrayList<Integer>();
        for (TreeItem selectedLeaf : allSelectedLeaves) {
            allSelectedIndexes.add(tree.indexOf(selectedLeaf));
        }
        return allSelectedIndexes;
    }

    public void expandAllLeaves() {
        List<TreeItem> allLeaves = ArrayUtil.asList(this.selectedTree.getItems());
        for (TreeItem leaf : allLeaves) {
            if (!this.isColumnGroupLeaf(leaf)) continue;
            ColumnGroupEntry columnGroupEntry = (ColumnGroupEntry)leaf.getData();
            leaf.setExpanded(!columnGroupEntry.isCollapsed());
        }
    }

    private boolean isColumnGroupLeaf(TreeItem treeItem) {
        if (ObjectUtils.isNotNull(treeItem)) {
            return treeItem.getData() instanceof ColumnGroupEntry;
        }
        return false;
    }

    private boolean isLastLeafSelected(Tree tree) {
        TreeItem[] selectedLeaves = tree.getSelection();
        int i = 0;
        while (i < selectedLeaves.length) {
            if (tree.indexOf(selectedLeaves[i]) + 1 == tree.getItemCount()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isFirstLeafSelected(Tree tree) {
        TreeItem[] selectedLeaves = tree.getSelection();
        int i = 0;
        while (i < selectedLeaves.length) {
            if (this.selectedTree.indexOf(selectedLeaves[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAnyLeafSelected(Tree tree) {
        TreeItem[] selectedLeaves = tree.getSelection();
        return selectedLeaves != null && selectedLeaves.length > 0;
    }

    private ColumnEntry getColumnEntryInLeaf(TreeItem leaf) {
        if (!this.isColumnGroupLeaf(leaf)) {
            return (ColumnEntry)leaf.getData();
        }
        return null;
    }

    public void removeAllLeaves() {
        this.selectedTree.removeAll();
        this.availableTree.removeAll();
    }

    public void setSelectionIncludingNested(List<Integer> indexes) {
        this.setSelectionIncludingNested(this.selectedTree, indexes);
    }

    protected void setSelection(Tree tree, List<Integer> indexes) {
        ArrayList<TreeItem> selectedLeaves = new ArrayList<TreeItem>();
        for (Integer leafIndex : indexes) {
            selectedLeaves.add(tree.getItem(leafIndex.intValue()));
        }
        tree.setSelection(selectedLeaves.toArray(new TreeItem[0]));
        tree.showSelection();
    }

    private void setSelectionIncludingNested(Tree tree, List<Integer> columnEntryIndexes) {
        Collection<TreeItem> allLeaves = ArrayUtil.asCollection(tree.getItems());
        ArrayList<TreeItem> selectedLeaves = new ArrayList<TreeItem>();
        for (TreeItem leaf : allLeaves) {
            if (!this.isColumnGroupLeaf(leaf)) {
                int index = this.getColumnEntryInLeaf(leaf).getIndex();
                if (!columnEntryIndexes.contains(index)) continue;
                selectedLeaves.add(leaf);
                continue;
            }
            Collection<TreeItem> columnGroupLeaves = ArrayUtil.asCollection(leaf.getItems());
            for (TreeItem columnGroupLeaf : columnGroupLeaves) {
                int index = this.getColumnEntryInLeaf(columnGroupLeaf).getIndex();
                if (!columnEntryIndexes.contains(index)) continue;
                selectedLeaves.add(columnGroupLeaf);
            }
        }
        tree.setSelection(selectedLeaves.toArray(new TreeItem[0]));
        this.setGroupsSelectionIfRequired(tree, columnEntryIndexes);
        tree.showSelection();
    }

    private void setGroupsSelectionIfRequired(Tree tree, List<Integer> columnEntryIndexes) {
        Collection<TreeItem> allLeaves = ArrayUtil.asCollection(tree.getItems());
        Collection<TreeItem> selectedLeaves = ArrayUtil.asCollection(tree.getSelection());
        for (TreeItem leaf : allLeaves) {
            if (!this.isColumnGroupLeaf(leaf)) continue;
            boolean markSelected = true;
            Collection<TreeItem> nestedLeaves = ArrayUtil.asCollection(leaf.getItems());
            for (TreeItem nestedLeaf : nestedLeaves) {
                ColumnEntry columnEntry = this.getColumnEntryInLeaf(nestedLeaf);
                if (columnEntryIndexes.contains(columnEntry.getIndex())) continue;
                markSelected = false;
            }
            if (!markSelected) continue;
            selectedLeaves.add(leaf);
        }
        tree.setSelection(selectedLeaves.toArray(new TreeItem[0]));
    }

    protected Tree getSelectedTree() {
        return this.selectedTree;
    }
}

