/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.connector;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;

public abstract class AbstractRegistrySourceConnector
implements IRegistrySourceConnector {
    protected Set<IConnectorListener> listeners;
    private String identifier;
    private boolean includeInDefaultViews;

    public AbstractRegistrySourceConnector(String identifier, boolean includeInDefaultViews) {
        Objects.requireNonNull(identifier, "Identifier must not be null!");
        this.identifier = identifier;
        this.includeInDefaultViews = includeInDefaultViews;
        this.listeners = new HashSet<IConnectorListener>();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean includeSpecificationsInDefaultViews() {
        return this.includeInDefaultViews;
    }

    @Override
    public void addListener(IConnectorListener listener) {
        Objects.requireNonNull(listener, "Listener must not be null!");
        boolean added = this.listeners.add(listener);
        if (added) {
            this.sendQuerySpecificationsToListener(listener);
        }
    }

    @Override
    public void removeListener(IConnectorListener listener) {
        Objects.requireNonNull(listener, "Listener must not be null!");
        this.listeners.remove(listener);
    }

    protected abstract void sendQuerySpecificationsToListener(IConnectorListener var1);
}

