/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.viatra.query.runtime.matchers.util.MapBackedMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.MemoryViewBackedMapView;

public interface IMemoryView<T>
extends Iterable<T> {
    public int getCount(T var1);

    public int getCountUnsafe(Object var1);

    public boolean containsNonZero(T var1);

    public boolean containsNonZeroUnsafe(Object var1);

    public int size();

    public boolean isEmpty();

    public Set<T> distinctValues();

    default public T theContainedVersionOf(T value) {
        if (this.containsNonZero(value)) {
            return value;
        }
        return null;
    }

    default public T theContainedVersionOfUnsafe(Object value) {
        if (this.containsNonZeroUnsafe(value)) {
            return (T)value;
        }
        return null;
    }

    default public Iterable<Map.Entry<T, Integer>> entriesWithMultiplicities() {
        return () -> {
            final Iterator<T> wrapped = this.distinctValues().iterator();
            return new Iterator<Map.Entry<T, Integer>>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Map.Entry<T, Integer> next() {
                    final Object key = wrapped.next();
                    final int count2 = IMemoryView.this.getCount(key);
                    return new Map.Entry<T, Integer>(){

                        @Override
                        public T getKey() {
                            return key;
                        }

                        @Override
                        public Integer getValue() {
                            return count2;
                        }

                        @Override
                        public Integer setValue(Integer value) {
                            throw new UnsupportedOperationException();
                        }

                        public String toString() {
                            return String.format("%d of %s", count2, key);
                        }
                    };
                }
            };
        };
    }

    default public void forEachEntryWithMultiplicities(BiConsumer<T, Integer> entryConsumer) {
        for (T value : this.distinctValues()) {
            entryConsumer.accept(value, this.getCount(value));
        }
    }

    default public Map<T, Integer> asMap() {
        return new MemoryViewBackedMapView(this);
    }

    public static <T> IMemoryView<T> fromMap(Map<T, Integer> wrapped) {
        return new MapBackedMemoryView<T>(wrapped);
    }

    public static <T> boolean equals(IMemoryView<T> self, Object obj) {
        if (obj instanceof IMemoryView) {
            IMemoryView other = (IMemoryView)obj;
            if (other.size() != self.size()) {
                return false;
            }
            for (Map.Entry<T, Integer> entry : other.entriesWithMultiplicities()) {
                if (entry.getValue().equals(self.getCountUnsafe(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> int hashCode(IMemoryView<T> memory) {
        int hashCode = 0;
        for (T value : memory.distinctValues()) {
            hashCode += value.hashCode() ^ Integer.hashCode(memory.getCount(value));
        }
        return hashCode;
    }
}

