/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.net.URI;
import java.util.concurrent.Callable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.ui.internal.Activator;
import org.eclipse.userstorage.ui.internal.MultiLink;
import org.eclipse.userstorage.ui.internal.SystemBrowser;
import org.eclipse.userstorage.ui.internal.UIUtil;

public class CredentialsComposite
extends Composite {
    public static final Point INITIAL_SIZE = new Point(600, 500);
    private final Callable<URI> createAccountURIProvider = new Callable<URI>(){

        @Override
        public URI call() throws Exception {
            return CredentialsComposite.this.service.getCreateAccountURI();
        }
    };
    private final Callable<URI> editAccountURIProvider = new Callable<URI>(){

        @Override
        public URI call() throws Exception {
            return CredentialsComposite.this.service.getEditAccountURI();
        }
    };
    private final Callable<URI> recoverPasswordURIProvider = new Callable<URI>(){

        @Override
        public URI call() throws Exception {
            return CredentialsComposite.this.service.getRecoverPasswordURI();
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CredentialsComposite.this.credentials = new Credentials(CredentialsComposite.this.usernameText.getText(), CredentialsComposite.this.passwordText.getText());
            CredentialsComposite.this.updateEnablement();
        }
    };
    private final boolean showServiceCredentials;
    private IStorageService service;
    private Credentials credentials;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label horizontalSpacer;
    private boolean termsOfUseAgreed;
    private Button termsOfUseButton;
    private MultiLink termsOfUseMultiLink;
    private Label verticalSpacer;
    private Link createAccountLink;
    private Link editAccountLink;
    private Link recoverPasswordLink;
    private boolean valid;

    public CredentialsComposite(Composite parent, int style, int marginWidth, int marginHeight, boolean showServiceCredentials) {
        super(parent, style);
        this.showServiceCredentials = showServiceCredentials;
        GridLayout layout = UIUtil.createGridLayout(this.getGridColumns());
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        this.setLayout((Layout)layout);
        this.createUI(this, layout.numColumns);
        this.setCredentials(null);
    }

    public IStorageService getService() {
        return this.service;
    }

    public void setService(IStorageService service) {
        this.service = service;
        if (service != null) {
            String termsOfUse = service.getTermsOfUseLink();
            if (StringUtil.isEmpty((String)termsOfUse)) {
                this.hideTermsOfUse();
            } else {
                int columns = this.getGridColumns();
                this.horizontalSpacer.setVisible(true);
                this.horizontalSpacer.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                this.termsOfUseButton.setVisible(true);
                this.termsOfUseButton.setLayoutData((Object)new GridData(131072, 128, false, false));
                this.termsOfUseMultiLink.setLayoutData(new GridData(16384, 128, true, false, columns - 2, 1));
                this.termsOfUseMultiLink.setVisible(true);
                this.termsOfUseMultiLink.setText(termsOfUse);
                this.verticalSpacer.setVisible(true);
                this.verticalSpacer.setLayoutData((Object)new GridData(4, 4, true, false, columns, 1));
            }
            if (this.showServiceCredentials) {
                this.setCredentials(((StorageService)service).getCredentials());
                this.setTermsOfUseAgreed(((StorageService)service).isTermsOfUseAgreed());
            }
        } else {
            this.hideTermsOfUse();
            if (this.showServiceCredentials) {
                this.setCredentials(null);
                this.setTermsOfUseAgreed(false);
            }
        }
        this.updateEnablement();
        this.layout();
    }

    public boolean isTermsOfUseAgreed() {
        return this.termsOfUseAgreed;
    }

    public void setTermsOfUseAgreed(boolean termsOfUseAgreed) {
        this.termsOfUseAgreed = termsOfUseAgreed;
        this.termsOfUseButton.setSelection(termsOfUseAgreed);
        this.updateEnablement();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
        if (credentials != null) {
            this.usernameText.setText(StringUtil.safe((String)credentials.getUsername()));
            this.passwordText.setText(StringUtil.safe((String)credentials.getPassword()));
        } else {
            this.usernameText.setText("");
            this.passwordText.setText("");
        }
    }

    public int getGridColumns() {
        return 3;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(true);
        this.usernameLabel.setEnabled(enabled);
        this.usernameText.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.passwordText.setEnabled(enabled);
        this.createAccountLink.setEnabled(enabled);
        this.editAccountLink.setEnabled(enabled);
        this.recoverPasswordLink.setEnabled(enabled);
    }

    protected void createUI(Composite parent, int columns) {
        this.usernameLabel = new Label(parent, 0);
        this.usernameLabel.setText("User name:");
        this.usernameText = new Text(parent, 2048);
        this.usernameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns - 1, 1));
        this.usernameText.addModifyListener(this.modifyListener);
        this.passwordLabel = new Label(parent, 0);
        this.passwordLabel.setText("Password:");
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns - 1, 1));
        this.passwordText.addModifyListener(this.modifyListener);
        this.horizontalSpacer = new Label(parent, 0);
        this.termsOfUseButton = new Button(parent, 32);
        this.termsOfUseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsComposite.this.termsOfUseAgreed = CredentialsComposite.this.termsOfUseButton.getSelection();
                CredentialsComposite.this.updateEnablement();
            }
        });
        this.termsOfUseMultiLink = new MultiLink.ForSystemBrowser(parent, 64);
        this.verticalSpacer = new Label(parent, 0);
        this.createAccountLink = this.createLink(parent, columns, "Create an account", this.createAccountURIProvider);
        this.editAccountLink = this.createLink(parent, columns, "Edit your account", this.editAccountURIProvider);
        this.recoverPasswordLink = this.createLink(parent, columns, "Recover your password", this.recoverPasswordURIProvider);
        this.hideTermsOfUse();
    }

    protected void validate() {
    }

    private void updateEnablement() {
        String termsOfUseLink;
        boolean enabled = this.isEnabled() && this.service != null;
        this.enableLink(this.createAccountLink, this.createAccountURIProvider, enabled);
        this.enableLink(this.editAccountLink, this.editAccountURIProvider, enabled);
        this.enableLink(this.recoverPasswordLink, this.recoverPasswordURIProvider, enabled);
        if (enabled && !StringUtil.isEmpty((String)(termsOfUseLink = this.service.getTermsOfUseLink())) && !this.termsOfUseAgreed) {
            this.valid = false;
            this.validate();
            return;
        }
        this.valid = enabled;
        this.validate();
    }

    private Link createLink(Composite parent, int columns, final String label, final Callable<URI> uriProvider) {
        new Label(parent, 0);
        final Link link = new Link(parent, 0);
        link.setText("<a>" + label + "</a>");
        link.setLayoutData((Object)new GridData(4, 4, true, false, columns - 1, 1));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (link.isEnabled()) {
                    try {
                        String uri = ((URI)uriProvider.call()).toString();
                        SystemBrowser.openSafe(CredentialsComposite.this.getShell(), uri, "Go to " + uri + " to " + label.toLowerCase() + ".");
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                    }
                }
            }
        });
        return link;
    }

    private void enableLink(Link link, Callable<URI> uriProvider, boolean enabled) {
        try {
            link.setEnabled(enabled && uriProvider.call() != null);
        }
        catch (Exception exception) {}
    }

    private void hideTermsOfUse() {
        this.horizontalSpacer.setVisible(false);
        this.horizontalSpacer.setLayoutData((Object)CredentialsComposite.emptyGridData(1, 1));
        this.termsOfUseButton.setVisible(false);
        this.termsOfUseButton.setLayoutData((Object)CredentialsComposite.emptyGridData(1, 1));
        this.termsOfUseMultiLink.setVisible(false);
        this.termsOfUseMultiLink.setLayoutData(CredentialsComposite.emptyGridData(this.getGridColumns() - 2, 1));
        this.termsOfUseMultiLink.setText("");
        this.verticalSpacer.setVisible(false);
        this.verticalSpacer.setLayoutData((Object)CredentialsComposite.emptyGridData(this.getGridColumns(), 1));
    }

    private static GridData emptyGridData(int horizontalSpan, int verticalSpan) {
        GridData gridData = new GridData(0, 0);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalSpan = verticalSpan;
        return gridData;
    }
}

