/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ISequenceEventsTreeIterator;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;

public class ShiftDescendantMessagesOperation
extends ShiftMessagesOperation {
    private ISequenceEvent parent;
    private final boolean fromTop;
    private boolean ignoreContainedReflexiveMessage;
    private Range oldParentRange;
    private Range newParentRange;
    private ISequenceEvent finalGrandParent;

    public ShiftDescendantMessagesOperation(ISequenceEvent parent, int deltaY) {
        this(parent, deltaY, false, true, true);
    }

    public ShiftDescendantMessagesOperation(ISequenceEvent parent, int deltaY, boolean revert, boolean move, boolean fromTop) {
        super(MessageFormat.format(Messages.ShifDescendantMessagesOperation_operationName, deltaY), deltaY, revert, move);
        this.parent = parent;
        this.fromTop = fromTop;
        this.oldParentRange = parent.getVerticalRange();
        this.newParentRange = this.getNewParentRange();
        this.finalGrandParent = null;
    }

    public ShiftDescendantMessagesOperation(ISequenceEvent parent, ISequenceEvent finalGrandParent, int deltaY, boolean ignoreContainedReflexiveMessage) {
        this(parent, deltaY);
        this.finalGrandParent = finalGrandParent;
        this.ignoreContainedReflexiveMessage = ignoreContainedReflexiveMessage;
    }

    @Override
    public Void execute() {
        HashSet<ISequenceEvent> descendants = new HashSet<ISequenceEvent>();
        this.populateMessageToShift(descendants);
        super.execute();
        HashSet<Edge> allConnections = new HashSet<Edge>();
        ISequenceEventsTreeIterator iter = new ISequenceEventsTreeIterator(this.parent, true);
        while (iter.hasNext()) {
            ISequenceEvent iSequenceEvent = (ISequenceEvent)iter.next();
            this.populateConnections(allConnections, iSequenceEvent.getNotationView());
        }
        for (Edge conn : allConnections) {
            if (descendants.contains(conn) || !this.isNoteAttachment(conn) && !this.isNonSequenceEdgeAttachment(conn)) continue;
            this.shiftAnchor(conn);
        }
        return null;
    }

    private void populateMessageToShift(Set<ISequenceEvent> descendants) {
        if (this.finalGrandParent != null) {
            View model = this.parent.getNotationView();
            for (ISequenceEvent child : this.finalGrandParent.getSubEvents()) {
                if (child.getNotationView() != model) continue;
                this.parent = child;
                break;
            }
        }
        this.populate(descendants);
        Predicate<Message> filterReflexiveMessage = new Predicate<Message>(){

            public boolean apply(Message input) {
                return !input.isReflective();
            }
        };
        if (this.ignoreContainedReflexiveMessage) {
            Iterables.addAll((Collection)this.messagesToShift, (Iterable)Iterables.filter((Iterable)Iterables.filter(descendants, Message.class), (Predicate)filterReflexiveMessage));
        } else {
            Iterables.addAll((Collection)this.messagesToShift, (Iterable)Iterables.filter(descendants, Message.class));
        }
    }

    private void populateConnections(Set<Edge> allConnections, View part) {
        Iterables.addAll(allConnections, (Iterable)Iterables.filter((Iterable)part.getSourceEdges(), Edge.class));
        Iterables.addAll(allConnections, (Iterable)Iterables.filter((Iterable)part.getTargetEdges(), Edge.class));
    }

    private boolean isNoteAttachment(Edge conn) {
        return conn != null && GMFNotationHelper.isNoteAttachment((Edge)conn);
    }

    private boolean isNonSequenceEdgeAttachment(Edge conn) {
        return conn != null && conn.getElement() instanceof DEdge && !ISequenceElementAccessor.getMessage((View)conn).some();
    }

    private void shiftAnchor(Edge edge) {
        boolean isOutgoing = Iterables.contains((Iterable)Iterables.transform((Iterable)this.movedElements, (Function)ISequenceElement.NOTATION_VIEW), (Object)edge.getSource());
        if (isOutgoing) {
            IdentityAnchor sourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
            int sourceAnchorLocation = SequenceGraphicalHelper.getAnchorAbsolutePosition(sourceAnchor, this.oldParentRange);
            PrecisionPoint position = BaseSlidableAnchor.parseTerminalString((String)sourceAnchor.getId());
            position.setPreciseY(this.newParentRange.getProportionalLocation(sourceAnchorLocation));
            String terminal = new SlidableAnchor(null, position).getTerminal();
            sourceAnchor.setId(terminal);
        } else {
            IdentityAnchor targetAnchor = (IdentityAnchor)edge.getTargetAnchor();
            int targetAnchorLocation = SequenceGraphicalHelper.getAnchorAbsolutePosition(targetAnchor, this.oldParentRange);
            PrecisionPoint position = BaseSlidableAnchor.parseTerminalString((String)targetAnchor.getId());
            position.setPreciseY(this.newParentRange.getProportionalLocation(targetAnchorLocation));
            String terminal = new SlidableAnchor(null, position).getTerminal();
            targetAnchor.setId(terminal);
        }
    }

    @Override
    protected int getDeltaY(Edge edge, boolean source) {
        if (!this.move) {
            IdentityAnchor anchor = source ? (IdentityAnchor)edge.getSourceAnchor() : (IdentityAnchor)edge.getTargetAnchor();
            return this.getDeltaY(anchor);
        }
        return super.getDeltaY(edge, source);
    }

    private int getDeltaY(IdentityAnchor anchor) {
        double oldAnchorLocation = SequenceGraphicalHelper.getAnchorAbsolutePosition(anchor, this.oldParentRange);
        double newAnchorLocation = SequenceGraphicalHelper.getAnchorAbsolutePosition(anchor, this.newParentRange);
        return (int)(oldAnchorLocation - newAnchorLocation);
    }

    private void populate(Set<ISequenceEvent> descendants) {
        if (this.move) {
            descendants.addAll(new ISequenceEventQuery(this.parent).getAllDescendants(true));
            Iterables.addAll((Collection)this.movedElements, (Iterable)Iterables.filter(descendants, AbstractNodeEvent.class));
        } else {
            descendants.addAll(new ISequenceEventQuery(this.parent).getAllDescendants(true));
            this.movedElements.add(this.parent);
        }
        ArrayList compoundEvents = new ArrayList();
        for (AbstractNodeEvent eep : Iterables.filter(descendants, AbstractNodeEvent.class)) {
            compoundEvents.addAll(EventEndHelper.getCompoundEvents((ISequenceEvent)eep));
        }
        Iterables.addAll(descendants, compoundEvents);
        if (this.parent instanceof Lifeline) {
            this.movedElements.add(this.parent);
        }
    }

    private Range getNewParentRange() {
        int newLowerBound = this.oldParentRange.getLowerBound();
        int newUppeRBound = this.oldParentRange.getUpperBound();
        if (this.move) {
            newLowerBound += this.deltaY;
            newUppeRBound += this.deltaY;
        } else if (this.fromTop) {
            newLowerBound += this.deltaY;
        } else {
            newUppeRBound += this.deltaY;
        }
        return new Range(newLowerBound, newUppeRBound);
    }
}

