/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsModuleNewHelper;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.xml.sax.SAXException;

public class JaxWsModuleNewOperation
implements IOperation {
    private IJavaProject m_serverModule;
    private String m_artifactId;
    private IProject m_createdProject;

    @Override
    public String getOperationName() {
        return "Create new Jax-Ws Module";
    }

    @Override
    public void validate() {
        Validate.notNull((Object)this.getServerModule(), (String)"Target module pom file must be specified.", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.getServerModule().exists(), (String)"Target module pom file could not be found.", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getArtifactId()));
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)100);
        try {
            IFile pomFile = this.getServerModule().getProject().getFile("pom.xml");
            if (!pomFile.isAccessible()) {
                throw new CoreException((IStatus)new ScoutStatus("pom.xml could not be found in module '" + this.getServerModule().getElementName() + "'."));
            }
            if (progress.isCanceled()) {
                return;
            }
            progress.worked(5);
            File createdProjectDir = JaxWsModuleNewHelper.createModule((File)pomFile.getLocation().toFile(), (String)this.getArtifactId());
            progress.worked(10);
            this.setCreatedProject(this.importIntoWorkspace(createdProjectDir, (IProgressMonitor)progress.newChild(70)));
            Set<IProject> modifiedProjects = this.getModifiedResources(createdProjectDir);
            modifiedProjects.add(this.getCreatedProject());
            modifiedProjects.add(this.getServerModule().getProject());
            S2eUtils.mavenUpdate(modifiedProjects, false, true, false, true, (IProgressMonitor)progress.newChild(15));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new ScoutStatus("Unable to create Jax-Ws Module.", e));
        }
    }

    protected IProject importIntoWorkspace(File createdProjectDir, IProgressMonitor monitor) throws CoreException {
        Set<MavenProjectInfo> projects = Collections.singleton(new MavenProjectInfo(createdProjectDir.getName(), new File(createdProjectDir, "pom.xml"), null, null));
        List importedProjects = MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), monitor);
        if (importedProjects == null || importedProjects.isEmpty()) {
            throw new CoreException((IStatus)new ScoutStatus("Unable to import newly created project into workspace."));
        }
        return ((IMavenProjectImportResult)importedProjects.iterator().next()).getProject();
    }

    protected Set<IProject> getModifiedResources(File createdProjectDir) throws CoreException {
        try {
            File parentPom = JaxWsModuleNewHelper.getParentPomOf((File)new File(createdProjectDir, "pom.xml"));
            if (parentPom == null) {
                return Collections.emptySet();
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] resources = root.findFilesForLocationURI(parentPom.toURI());
            HashSet<IProject> result = new HashSet<IProject>(resources.length);
            IFile[] iFileArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                result.add(f.getProject());
                ++n2;
            }
            return result;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    public IJavaProject getServerModule() {
        return this.m_serverModule;
    }

    public void setServerModule(IJavaProject serverModule) {
        this.m_serverModule = serverModule;
    }

    public IProject getCreatedProject() {
        return this.m_createdProject;
    }

    protected void setCreatedProject(IProject createdProject) {
        this.m_createdProject = createdProject;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }
}

