/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssBorder;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.CssColor;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssFont;
import org.eclipse.rap.rwt.internal.theme.CssImage;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Widget;

public abstract class ThemeAdapter {
    private final WidgetMatcher matcher = new WidgetMatcher();

    public ThemeAdapter() {
        this.configureMatcher(this.matcher);
    }

    public static String getPrimaryElement(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        ThemeableWidget thWidget = ThemeAdapter.findThemeableWidget(widget);
        if (thWidget == null || thWidget.elements == null) {
            throw new RuntimeException("No themeable widget found for " + widgetClass.getName());
        }
        return thWidget.elements[0].getName();
    }

    protected abstract void configureMatcher(WidgetMatcher var1);

    protected Color getCssColor(String cssElement, String cssProperty, Widget widget) {
        CssValue cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return CssColor.createColor((CssColor)cssValue);
    }

    protected Font getCssFont(String cssElement, String cssProperty, Widget widget) {
        CssValue cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return CssFont.createFont((CssFont)cssValue);
    }

    protected BoxDimensions getCssBorder(String cssElement, Widget widget) {
        int top = this.getCssBorderWidth(cssElement, "border-top", widget);
        int right = this.getCssBorderWidth(cssElement, "border-right", widget);
        int bottom = this.getCssBorderWidth(cssElement, "border-bottom", widget);
        int left = this.getCssBorderWidth(cssElement, "border-left", widget);
        return new BoxDimensions(top, right, bottom, left);
    }

    protected int getCssBorderWidth(String cssElement, String cssProperty, Widget widget) {
        CssValue cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((CssBorder)cssValue).width;
    }

    protected int getCssDimension(String cssElement, String cssProperty, Widget widget) {
        CssValue cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((CssDimension)cssValue).value;
    }

    protected CssBoxDimensions getCssBoxDimensions(String cssElement, String cssProperty, Widget widget) {
        return (CssBoxDimensions)ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
    }

    protected Size getCssImageSize(String cssElement, String cssProperty, Widget widget) {
        CssImage image = (CssImage)ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return image.getSize();
    }

    private static ThemeableWidget findThemeableWidget(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        ThemeManager manager = ContextProvider.getApplicationContext().getThemeManager();
        ThemeableWidget result = manager.getThemeableWidget(widgetClass);
        while ((result == null || result.elements == null) && widgetClass.getSuperclass() != null) {
            widgetClass = widgetClass.getSuperclass();
            result = manager.getThemeableWidget(widgetClass);
        }
        return result;
    }
}

