/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IIdAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLFeatureAxisManager;
import org.eclipse.papyrus.uml.nattable.provider.UMLStereotypeRestrictedPropertyContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypePropertyAxisManager
extends UMLFeatureAxisManager
implements IIdAxisManager {
    @Override
    public boolean isAllowedContents(Object object) {
        Property prop;
        Element owner;
        boolean result = false;
        if (object instanceof Property && (owner = (prop = (Property)object).getOwner()) instanceof Stereotype) {
            while (owner.getOwner() instanceof Package && !result) {
                owner = owner.getOwner();
                result = owner instanceof Profile;
            }
            if (result) {
                result = EMFHelper.isReadOnly((EObject)prop);
            }
        }
        return result;
    }

    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        Set<Object> propertiesToAdd = this.getPropertiesToAdd(objectToAdd);
        if (!propertiesToAdd.isEmpty()) {
            return this.getAddAxisCommand(domain, propertiesToAdd);
        }
        return null;
    }

    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        Set<Object> propertiesToAdd = this.getPropertiesToAdd(objectToAdd);
        if (!propertiesToAdd.isEmpty()) {
            return this.getAddAxisCommand(domain, propertiesToAdd, index);
        }
        return null;
    }

    protected Set<Object> getPropertiesToAdd(Collection<Object> objectToAdd) {
        HashSet appliedStereotypes = new HashSet();
        for (Object current : objectToAdd) {
            if (!(current instanceof Element)) continue;
            appliedStereotypes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet<Object> propertiesToAdd = new HashSet<Object>();
        for (Stereotype stereotype : appliedStereotypes) {
            propertiesToAdd.addAll(StereotypeUtil.getAllStereotypePropertiesWithoutBaseProperties((Stereotype)stereotype));
        }
        return propertiesToAdd;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd), objectToAdd);
        }
        return null;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd, (int)index), objectToAdd);
        }
        return null;
    }

    protected Collection<IAxis> getAxisToAdd(Collection<Object> objectToAdd) {
        ArrayList<IAxis> toAdd = new ArrayList<IAxis>();
        ArrayList<String> allPropertyQN = new ArrayList<String>();
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object)) continue;
            allPropertyQN.add("property_of_stereotype:/" + ((NamedElement)object).getQualifiedName());
        }
        allPropertyQN.removeAll(this.getElements());
        if (!allPropertyQN.isEmpty()) {
            for (String propQN : allPropertyQN) {
                FeatureIdAxis newAxis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
                newAxis.setElement(propQN);
                newAxis.setManager(this.representedAxisManager);
                toAdd.add((IAxis)newAxis);
            }
        }
        return toAdd;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return new UMLStereotypeRestrictedPropertyContentProvider(this, isRestricted);
    }

    @Override
    public Collection<Object> getAllPossibleAxis() {
        return this.getRootProfiles();
    }

    private Collection<Object> getRootProfiles() {
        EObject context = this.getTableManager().getTable().getContext();
        assert (context instanceof Element);
        EList allAppliedProfiles = ((Element)context).getNearestPackage().getAllAppliedProfiles();
        HashSet<Object> profiles = new HashSet<Object>();
        for (Profile profile : allAppliedProfiles) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)profile);
            profiles.add(rootContainer);
        }
        return profiles;
    }

    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> umlProperties) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        ArrayList<String> propIdToDestroy = new ArrayList<String>();
        for (Object current : umlProperties) {
            if (current instanceof Property && ((Property)current).eContainer() instanceof Stereotype) {
                propIdToDestroy.add("property_of_stereotype:/" + ((NamedElement)current).getQualifiedName());
                continue;
            }
            if (current instanceof String) {
                propIdToDestroy.add((String)current);
                continue;
            }
            if (!(current instanceof IAxis)) continue;
            propIdToDestroy.add(((IAxis)current).getElement().toString());
        }
        for (Object current : this.getRepresentedContentProvider().getAxis()) {
            String propId;
            if (!(current instanceof IdAxis) || !propIdToDestroy.contains(propId = AxisUtils.getPropertyId((Object)current))) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new AbstractAxisManager.RemoveCommandWrapper((AbstractAxisManager)this, (Command)new GMFtoEMFCommandWrapper((ICommand)compositeCommand), umlProperties);
        }
        return null;
    }

    public Object resolvedPath(String path) {
        if (path.startsWith("property_of_stereotype:/")) {
            return UMLTableUtils.getRealStereotypeProperty(this.getTableContext(), path);
        }
        return null;
    }

    public String getElementAxisName(IAxis axis) {
        String returnedValue = null;
        if (axis instanceof FeatureIdAxis) {
            String elementId = ((FeatureIdAxis)axis).getElement();
            Object resolvedElement = this.resolvedPath(elementId);
            if (resolvedElement instanceof NamedElement) {
                returnedValue = UMLLabelInternationalization.getInstance().getLabel((NamedElement)resolvedElement);
            } else {
                elementId = elementId.replace("property_of_stereotype:/", "");
                String[] splitedElementId = elementId.split("::");
                returnedValue = splitedElementId[splitedElementId.length - 1];
            }
        }
        return returnedValue != null ? returnedValue : super.getElementAxisName(axis);
    }
}

