/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.editor.xml.internal.lifecycle.LifecycleMappingResolution;
import org.eclipse.m2e.editor.xml.internal.lifecycle.WorkspaceLifecycleMappingResolution;
import org.eclipse.m2e.editor.xml.internal.markers.IdPartRemovalResolution;
import org.eclipse.m2e.editor.xml.internal.markers.IgnoreWarningResolution;
import org.eclipse.m2e.editor.xml.internal.markers.ManagedVersionRemovalResolution;
import org.eclipse.m2e.editor.xml.internal.markers.SchemaCompletionResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class MavenMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        if (hint != null) {
            if (MavenMarkerResolutionGenerator.isMissingSchema(hint)) {
                return new IMarkerResolution[]{new SchemaCompletionResolution(marker)};
            }
            if (MavenMarkerResolutionGenerator.isUnneededParentVersion(hint)) {
                return new IMarkerResolution[]{new IdPartRemovalResolution(marker, true)};
            }
            if (MavenMarkerResolutionGenerator.isUnneededParentGroupId(hint)) {
                return new IMarkerResolution[]{new IdPartRemovalResolution(marker, false)};
            }
            if (MavenMarkerResolutionGenerator.isDependencyVersionOverride(hint)) {
                return new IMarkerResolution[]{new ManagedVersionRemovalResolution(marker, true), new IgnoreWarningResolution(marker, "$NO-MVN-MAN-VER$")};
            }
            if (MavenMarkerResolutionGenerator.isPluginVersionOverride(hint)) {
                return new IMarkerResolution[]{new ManagedVersionRemovalResolution(marker, false), new IgnoreWarningResolution(marker, "$NO-MVN-MAN-VER$")};
            }
            if (hint.equals("not_covered_mojo_execution")) {
                return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
            }
            if (hint.equals("missing_configurator")) {
                return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
            }
            if (marker.getAttribute("severity", 2) == 2 && hint.equals("implicit_lifecyclemaping")) {
                return new IMarkerResolution[]{new LifecycleMappingResolution(marker, PluginExecutionAction.ignore), new WorkspaceLifecycleMappingResolution(marker, PluginExecutionAction.ignore)};
            }
        }
        return new IMarkerResolution[0];
    }

    static boolean isPluginVersionOverride(String hint) {
        return hint.equals("managed_plugin_override");
    }

    static boolean isDependencyVersionOverride(String hint) {
        return hint.equals("managed_dependency_override");
    }

    static boolean isUnneededParentGroupId(String hint) {
        return "parent_groupid".equals(hint);
    }

    static boolean isUnneededParentVersion(String hint) {
        return "parent_version".equals(hint);
    }

    static boolean isMissingSchema(String hint) {
        return "missing_schema".equals(hint);
    }

    public boolean hasResolutions(IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        return hint != null;
    }
}

