/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ConnectAutAgentBP;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionGUIController;
import org.eclipse.jubula.client.ui.rcp.utils.AutAgentManager;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class AUTAgentConnectHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String AUT_AGENT_NAME_TO_CONNECT = "org.eclipse.jubula.client.ui.rcp.commands.ConnectToAUTAgentCommand.parameter.name";
    public static final String AUT_AGENT_PORT_TO_CONNECT = "org.eclipse.jubula.client.ui.rcp.commands.ConnectToAUTAgentCommand.parameter.port";

    public Object executeImpl(ExecutionEvent event) throws ExecutionException {
        Integer portNo;
        String name;
        block5: {
            try {
                name = event.getParameter(AUT_AGENT_NAME_TO_CONNECT);
                String port = event.getParameter(AUT_AGENT_PORT_TO_CONNECT);
                portNo = null;
                if (port != null && name != null) {
                    portNo = Integer.parseInt(event.getParameter(AUT_AGENT_PORT_TO_CONNECT));
                    break block5;
                }
                AutAgentManager.AutAgent fallbackAgent = ConnectAutAgentBP.getInstance().getWorkingAutAgent();
                if (fallbackAgent != null) {
                    name = fallbackAgent.getName();
                    portNo = fallbackAgent.getPort();
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        AutAgentManager.AutAgent autAgent = new AutAgentManager.AutAgent(name, portNo);
        TestExecutionGUIController.connectToAutAgent(autAgent);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        Object oName = parameters.get(AUT_AGENT_NAME_TO_CONNECT);
        Object oPort = parameters.get(AUT_AGENT_PORT_TO_CONNECT);
        if (oName == null || oPort == null) {
            return;
        }
        String name = oName.toString();
        String port = oPort.toString();
        boolean setChecked = false;
        AutAgentManager.AutAgent mostRecent = ConnectAutAgentBP.getInstance().getWorkingAutAgent();
        if (mostRecent != null) {
            String mostRecentName = mostRecent.getName();
            String mostRecentPort = mostRecent.getPort().toString();
            if (name.equals(mostRecentName) && port.equals(mostRecentPort)) {
                setChecked = true;
            }
        }
        element.setChecked(setChecked);
    }
}

