/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.JoinTableAttributes;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectPropertyDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectTableDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JoinPropertiesPage
extends WizardPage {
    protected PersistenceUnit persistenceUnit;
    protected ResourceManager resourceManager;
    protected IProject project;
    protected String javaClass;
    protected Schema schema;
    protected Table table;
    protected Table inverseTable;
    protected EntityRefPropertyElem refElem;
    protected String tagName;
    private Composite joinPropsComposite;

    public JoinPropertiesPage(PersistenceUnit persistenceUnit, ResourceManager resourceManager, IProject project, String javaClass, Schema schema, Table table, Table inverseTable, EntityRefPropertyElem refElem) {
        super("Join Properties Page");
        this.persistenceUnit = persistenceUnit;
        this.resourceManager = resourceManager;
        this.project = project;
        this.javaClass = javaClass;
        this.refElem = refElem;
        this.schema = schema;
        this.table = table;
        this.inverseTable = inverseTable;
        this.setTitle(JptJpaUiMakePersistentMessages.JOIN_PROPS_PAGE_TITLE);
        this.setMessage(JptJpaUiMakePersistentMessages.JOIN_PROPS_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        composite.setLayoutData((Object)gd);
        this.joinPropsComposite = this.createJoinProps(composite);
        this.addListeners();
        this.setControl((Control)composite);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setVisible(boolean visible) {
        String newTagName;
        super.setVisible(visible);
        if (visible && !AnnotateMappingUtil.areEqual((Object)this.tagName, (Object)(newTagName = this.refElem.getTagName()))) {
            this.tagName = newTagName;
            this.initFields();
            this.refreshJoinProperties();
        }
    }

    protected Composite createJoinProps(Composite parent) {
        return null;
    }

    protected void refreshJoinProperties() {
    }

    protected Composite getJoinPropsComposite() {
        return this.joinPropsComposite;
    }

    protected void addListeners() {
    }

    protected void initFields() {
    }

    protected String getJoinTableName() {
        String joinTableName = null;
        JoinTableAttributes joinTableAttrs = this.refElem.getJoinTable();
        if (joinTableAttrs != null) {
            joinTableName = joinTableAttrs.getTableName();
        }
        return joinTableName;
    }

    protected boolean isJpa1_0Project() {
        return this.persistenceUnit.getJpaPlatform().getJpaVersion().getVersion().equals("1.0");
    }

    protected boolean isGeneric1_0Project() {
        return this.isJpa1_0Project() && this.persistenceUnit.getJpaPlatform().getConfig().getId().equals("generic");
    }

    protected void chooseJoinTable(Text joinTableText) {
        SelectTableDialog dlg = new SelectTableDialog(Display.getDefault().getActiveShell(), this.resourceManager, this.schema);
        if (dlg.open() == 0) {
            joinTableText.setText(dlg.getSelectedTable());
        }
    }

    protected void handleJoinTableChange(Text joinTableText) {
        String newJoinTable = joinTableText.getText();
        if (newJoinTable != null && newJoinTable.length() > 0) {
            JoinTableAttributes joinTblAttr = this.refElem.getJoinTable();
            if (joinTblAttr != null) {
                String oldJoinTable = joinTblAttr.getTableName();
                if (oldJoinTable == null || !oldJoinTable.equalsIgnoreCase(newJoinTable)) {
                    joinTblAttr.setTableName(newJoinTable);
                    joinTblAttr.setSchema(this.schema.getName());
                    joinTblAttr.removeAllJoinColumns();
                    joinTblAttr.removeAllInverseJoinColumns();
                }
            } else {
                joinTblAttr = new JoinTableAttributes();
                joinTblAttr.setTableName(newJoinTable);
                joinTblAttr.setSchema(this.schema.getName());
                this.refElem.setJoinTable(joinTblAttr);
            }
        } else {
            this.refElem.removeJoinTable();
        }
        this.refreshJoinProperties();
    }

    protected void chooseMappedBy(Text mappedByText) {
        SelectPropertyDialog dlg = new SelectPropertyDialog(Display.getDefault().getActiveShell(), this.project, this.javaClass, this.refElem, false);
        if (dlg.open() == 0) {
            mappedByText.setText(dlg.getSelectedProp());
        }
    }

    protected void handleMappedByChange(Text mappedByText) {
        if (mappedByText.getText() == null || mappedByText.getText().length() == 0) {
            this.refElem.removeMappedBy();
        } else {
            this.refElem.setMappedBy(mappedByText.getText());
        }
    }
}

