/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.beans.value.ChangeListener;
import javafx.scene.Parent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerContributionItem;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractZoomAction;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomScaleContributionItem
extends AbstractViewerContributionItem {
    public static final String ZOOM_SCALE_CONTRIBUTION_ITEM_ID = "ZoomScaleContributionItem";
    private static final int SCALE_MINIMUM = 1;
    private static final int SCALE_MAXIMUM = 10000;
    private static final double SCALE_TO_ZOOM_COEFF_BASE = 0.0312283;
    private static final double SCALE_TO_ZOOM_COEFF_EXPO = 6.93217E-4;
    private static final double ZOOM_TO_SCALE_COEFF_BASE = 1442.55;
    private static final double ZOOM_TO_SCALE_COEFF_EXPO = 32.0222;
    private ToolItem toolItem;
    private Scale zoomScale;
    private ChangeListener<? super Number> zoomListener;
    private AbstractZoomAction zoomAction = this.createZoomAction();

    public ZoomScaleContributionItem() {
        this.setId(ZOOM_SCALE_CONTRIBUTION_ITEM_ID);
    }

    protected int computeScaleValue(double zoomFactor) {
        return (int)Math.round(1442.55 * Math.log(32.0222 * zoomFactor));
    }

    protected double computeZoomFactor(int scaleValue) {
        return 0.0312283 * Math.pow(Math.E, 6.93217E-4 * (double)scaleValue);
    }

    protected AbstractZoomAction createZoomAction() {
        return new AbstractZoomAction("Zoom"){

            @Override
            protected double determineZoomFactor(double currentZoomFactor, Event event) {
                return (Double)event.data * 1.0 / currentZoomFactor;
            }
        };
    }

    public void dispose() {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.dispose();
        }
    }

    public void fill(Composite parent) {
        throw new UnsupportedOperationException();
    }

    public void fill(CoolBar parent, int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(Menu menu, int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(ToolBar tb, int index) {
        this.toolItem = new ToolItem(tb, 2, index);
        this.zoomScale = new Scale((Composite)tb, 256);
        this.zoomScale.setMinimum(1);
        this.zoomScale.setMaximum(10000);
        this.zoomScale.setSelection(5000);
        this.zoomScale.setSize(75, 100);
        this.toolItem.setWidth(this.zoomScale.getSize().x);
        this.toolItem.setControl((Control)this.zoomScale);
        this.zoomScale.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int sel = ZoomScaleContributionItem.this.zoomScale.getSelection();
                double zoom = ZoomScaleContributionItem.this.computeZoomFactor(sel);
                if (!(zoom > 0.0)) {
                    throw new IllegalStateException("Illegal zoom factor.");
                }
                Event event = new Event();
                event.data = zoom;
                ZoomScaleContributionItem.this.zoomAction.runWithEvent(event);
            }
        });
        if (this.isEnabled()) {
            double mxx = ((InfiniteCanvas)this.getViewer().getCanvas()).getContentTransform().getMxx();
            this.updateScaleValue(mxx);
        }
    }

    @Override
    protected void register() {
        if (this.zoomListener != null) {
            throw new IllegalStateException("Zoom listener is already registered.");
        }
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            InfiniteCanvas infiniteCanvas = (InfiniteCanvas)canvas;
            this.zoomListener = (a, o, n) -> this.updateScaleValue(n.doubleValue());
            infiniteCanvas.getContentTransform().mxxProperty().addListener(this.zoomListener);
            this.updateScaleValue(infiniteCanvas.getContentTransform().getMxx());
        }
    }

    @Override
    public void setAdaptable(IViewer viewer) {
        super.setAdaptable(viewer);
        this.zoomAction.setAdaptable(viewer);
    }

    @Override
    protected void unregister() {
        if (this.zoomListener == null) {
            throw new IllegalStateException("Zoom listener not yet registered.");
        }
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            ((InfiniteCanvas)canvas).getContentTransform().mxxProperty().removeListener(this.zoomListener);
            this.zoomListener = null;
        }
    }

    protected void updateScaleValue(double zoomFactor) {
        if (this.zoomScale != null) {
            this.zoomScale.setSelection(this.computeScaleValue(zoomFactor));
        }
    }
}

