/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.emf.core.command.ILockableUndoCommand;
import org.eclipse.emf.facet.util.emf.core.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddResourceContentCommand
implements Command,
ILockableUndoCommand {
    private final Collection<EObject> newContent;
    private final Resource resource;
    private boolean enableUndo = true;

    public AddResourceContentCommand(Resource resource, Collection<EObject> content) {
        this.resource = resource;
        this.newContent = content;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.resource.getContents().addAll(this.newContent);
    }

    public boolean canUndo() {
        return this.enableUndo;
    }

    public void undo() {
        this.resource.getContents().removeAll(this.newContent);
    }

    public void redo() {
        this.resource.getContents().addAll(this.newContent);
    }

    public Collection<?> getResult() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        result.add(this.resource);
        return result;
    }

    public Collection<?> getAffectedObjects() {
        ArrayList<Object> affectedObjects = new ArrayList<Object>();
        affectedObjects.add(this.resource);
        affectedObjects.addAll(this.newContent);
        return affectedObjects;
    }

    public String getLabel() {
        return Messages.AddResourceContentCommand_Label;
    }

    public String getDescription() {
        return Messages.AddResourceContentCommand_Description;
    }

    public void dispose() {
    }

    public Command chain(Command command) {
        CompoundCommand result = new CompoundCommand();
        result.append((Command)this);
        result.append(command);
        return result;
    }

    @Override
    public void enableCanUndo(boolean enable) {
        this.enableUndo = enable;
    }
}

