/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class LocalAsgnNode
extends AssignableNode
implements INameNode {
    static final long serialVersionUID = 1118108700098164006L;
    private String name;
    private final int location;

    public LocalAsgnNode(ISourcePosition position, String name, int location, Node valueNode) {
        super(position, 52);
        this.name = name.intern();
        this.location = location;
        this.setValueNode(valueNode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List childNodes() {
        return LocalAsgnNode.createList(this.getValueNode());
    }
}

