/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathChange;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.ExternalFolderChange;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.PersistentTimeStampMap;
import org.eclipse.dltk.internal.core.ProjectReferenceChange;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int[] preResourceChangeEventMasks = new int[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal<DeltaProcessor> deltaProcessors = new ThreadLocal();
    public HashMap roots = new HashMap();
    public HashMap otherRoots = new HashMap();
    public HashMap oldRoots = new HashMap();
    public HashMap oldOtherRoots = new HashMap();
    public HashMap projectDependencies = new HashMap();
    public boolean rootsAreStale = true;
    private Set initializingThreads = Collections.synchronizedSet(new HashSet());
    public PersistentTimeStampMap externalTimeStamps;
    public PersistentTimeStampMap customTimeStamps;
    private HashMap<IProject, BuildpathChange> buildpathChanges = new HashMap();
    private HashMap<ScriptProject, BuildpathValidation> buildpathValidations = new HashMap();
    private HashMap<ScriptProject, ProjectReferenceChange> projectReferenceChanges = new HashMap();
    private HashMap externalFolderChanges = new HashMap();
    private HashSet<String> scriptProjectNamesCache;
    private HashSet<IModelElement> externalElementsToRefresh;

    public synchronized void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public synchronized void addForRefresh(IModelElement externalElement) {
        if (this.externalElementsToRefresh == null) {
            this.externalElementsToRefresh = new HashSet();
        }
        this.externalElementsToRefresh.add(externalElement);
    }

    public void addPreResourceChangedListener(IResourceChangeListener listener, int eventMask) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int n = i;
                this.preResourceChangeEventMasks[n] = this.preResourceChangeEventMasks[n] | eventMask;
                return;
            }
            ++i;
        }
        int length = this.preResourceChangeListeners.length;
        if (length == this.preResourceChangeListenerCount) {
            this.preResourceChangeListeners = new IResourceChangeListener[length * 2];
            System.arraycopy(this.preResourceChangeListeners, 0, this.preResourceChangeListeners, 0, length);
            this.preResourceChangeEventMasks = new int[length * 2];
            System.arraycopy(this.preResourceChangeEventMasks, 0, this.preResourceChangeEventMasks, 0, length);
        }
        this.preResourceChangeListeners[this.preResourceChangeListenerCount] = listener;
        this.preResourceChangeEventMasks[this.preResourceChangeListenerCount] = eventMask;
        ++this.preResourceChangeListenerCount;
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, ModelManager.getModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    public synchronized BuildpathChange addBuildpathChange(IProject project, IBuildpathEntry[] oldRawBuildpath, IBuildpathEntry[] oldResolvedBuildpath) {
        BuildpathChange change = this.buildpathChanges.get(project);
        if (change == null) {
            change = new BuildpathChange((ScriptProject)ModelManager.getModelManager().getModel().getScriptProject((IResource)project), oldRawBuildpath, oldResolvedBuildpath);
            this.buildpathChanges.put(project, change);
        } else {
            if (change.oldRawBuildpath == null) {
                change.oldRawBuildpath = oldRawBuildpath;
            }
            if (change.oldResolvedBuildpath == null) {
                change.oldResolvedBuildpath = oldResolvedBuildpath;
            }
        }
        return change;
    }

    public synchronized BuildpathChange getBuildpathChange(IProject project) {
        return this.buildpathChanges.get(project);
    }

    public synchronized HashMap<IProject, BuildpathChange> removeAllBuildpathChanges() {
        HashMap<IProject, BuildpathChange> result = this.buildpathChanges;
        this.buildpathChanges = new HashMap(result.size());
        return result;
    }

    public synchronized BuildpathValidation addBuildpathValidation(ScriptProject project) {
        BuildpathValidation validation = this.buildpathValidations.get(project);
        if (validation == null) {
            validation = new BuildpathValidation(project);
            this.buildpathValidations.put(project, validation);
        }
        return validation;
    }

    public synchronized void addExternalFolderChange(ScriptProject project, IBuildpathEntry[] oldResolvedClasspath) {
        ExternalFolderChange change = (ExternalFolderChange)this.externalFolderChanges.get(project);
        if (change == null) {
            change = new ExternalFolderChange(project, oldResolvedClasspath);
            this.externalFolderChanges.put(project, change);
        }
    }

    public synchronized void addProjectReferenceChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        ProjectReferenceChange change = this.projectReferenceChanges.get(project);
        if (change == null) {
            change = new ProjectReferenceChange(project, oldResolvedBuildpath);
            this.projectReferenceChanges.put(project, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeRoots() {
        HashMap<IPath, DeltaProcessor.RootInfo> newRoots = null;
        HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>> newOtherRoots = null;
        HashMap<IScriptProject, IScriptProject[]> newProjectDependencies = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                IScriptProject[] projects;
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                ModelManager.getModelManager().batchContainerInitializations = true;
                newRoots = new HashMap<IPath, DeltaProcessor.RootInfo>();
                newOtherRoots = new HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>>();
                newProjectDependencies = new HashMap<IScriptProject, IScriptProject[]>();
                Model model = ModelManager.getModelManager().getModel();
                try {
                    projects = model.getScriptProjects();
                }
                catch (ModelException e) {
                    if (addedCurrentThread) {
                        this.initializingThreads.remove(currentThread);
                    }
                    return;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    block26: {
                        IBuildpathEntry[] buildpath;
                        ScriptProject project = (ScriptProject)projects[i];
                        try {
                            buildpath = project.getResolvedBuildpath();
                        }
                        catch (ModelException e) {
                            break block26;
                        }
                        int j = 0;
                        int buildpathLength = buildpath.length;
                        while (j < buildpathLength) {
                            IBuildpathEntry entry = buildpath[j];
                            if (entry.getEntryKind() == 2) {
                                IScriptProject key = model.getScriptProject(entry.getPath().segment(0));
                                IScriptProject[] dependents = (IScriptProject[])newProjectDependencies.get(key);
                                if (dependents == null) {
                                    dependents = new IScriptProject[]{project};
                                } else {
                                    int dependentsLength = dependents.length;
                                    IScriptProject[] iScriptProjectArray = dependents;
                                    dependents = new IScriptProject[dependentsLength + 1];
                                    System.arraycopy(iScriptProjectArray, 0, dependents, 0, dependentsLength);
                                    dependents[dependentsLength] = project;
                                }
                                newProjectDependencies.put(key, dependents);
                            } else {
                                IPath path = entry.getPath();
                                if (newRoots.get(path) == null) {
                                    newRoots.put(path, new DeltaProcessor.RootInfo(project, path, ((BuildpathEntry)entry).fullInclusionPatternChars(), ((BuildpathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                } else {
                                    ArrayList<DeltaProcessor.RootInfo> rootList = (ArrayList<DeltaProcessor.RootInfo>)newOtherRoots.get(path);
                                    if (rootList == null) {
                                        rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                        newOtherRoots.put(path, rootList);
                                    }
                                    rootList.add(new DeltaProcessor.RootInfo(project, path, ((BuildpathEntry)entry).fullInclusionPatternChars(), ((BuildpathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (this.rootsAreStale && newRoots != null) {
                this.roots = newRoots;
                this.otherRoots = newOtherRoots;
                this.projectDependencies = newProjectDependencies;
                this.rootsAreStale = false;
            }
        }
    }

    public synchronized BuildpathValidation[] removeBuildpathValidations() {
        int length = this.buildpathValidations.size();
        if (length == 0) {
            return null;
        }
        BuildpathValidation[] validations = new BuildpathValidation[length];
        this.buildpathValidations.values().toArray(validations);
        this.buildpathValidations.clear();
        return validations;
    }

    public synchronized ProjectReferenceChange[] removeProjectReferenceChanges() {
        int length = this.projectReferenceChanges.size();
        if (length == 0) {
            return null;
        }
        ProjectReferenceChange[] updates = new ProjectReferenceChange[length];
        this.projectReferenceChanges.values().toArray(updates);
        this.projectReferenceChanges.clear();
        return updates;
    }

    public synchronized Set<IModelElement> removeExternalElementsToRefresh() {
        HashSet<IModelElement> result = this.externalElementsToRefresh;
        this.externalElementsToRefresh = null;
        return result;
    }

    public synchronized void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    public void removePreResourceChangedListener(IResourceChangeListener listener) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int length = this.preResourceChangeListeners.length;
                IResourceChangeListener[] newListeners = new IResourceChangeListener[length];
                int[] newEventMasks = new int[length];
                System.arraycopy(this.preResourceChangeListeners, 0, newListeners, 0, i);
                System.arraycopy(this.preResourceChangeEventMasks, 0, newEventMasks, 0, i);
                int trailingLength = this.preResourceChangeListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.preResourceChangeListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.preResourceChangeEventMasks, i + 1, newEventMasks, i, trailingLength);
                }
                this.preResourceChangeListeners = newListeners;
                this.preResourceChangeEventMasks = newEventMasks;
                --this.preResourceChangeListenerCount;
                return;
            }
            ++i;
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            final IResourceChangeListener listener = this.preResourceChangeListeners[i];
            if ((this.preResourceChangeEventMasks[i] & event.getType()) != 0) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre script resource change notification");
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
            ++i;
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (event.getType() == 1) {
                this.deltaProcessors.set(null);
            }
        }
    }

    public Map<IPath, Long> getExternalLibTimeStamps() {
        if (this.externalTimeStamps == null) {
            this.externalTimeStamps = new PersistentTimeStampMap(this.getTimeStampsFile());
        }
        return this.externalTimeStamps.getTimestamps();
    }

    public Map<IPath, Long> getCustomTimeStamps() {
        if (this.customTimeStamps == null) {
            this.customTimeStamps = new PersistentTimeStampMap(this.getCustomTimeStampsFile());
        }
        return this.customTimeStamps.getTimestamps();
    }

    public IScriptProject findProject(String name) {
        if (this.getOldScriptProjectNames().contains(name)) {
            return ModelManager.getModelManager().getModel().getScriptProject(name);
        }
        return null;
    }

    public synchronized HashSet<String> getOldScriptProjectNames() {
        if (this.scriptProjectNamesCache == null) {
            IScriptProject[] projects;
            HashSet<String> result = new HashSet<String>();
            try {
                projects = ModelManager.getModelManager().getModel().getScriptProjects();
            }
            catch (ModelException e) {
                return this.scriptProjectNamesCache;
            }
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IScriptProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.scriptProjectNamesCache = result;
            return this.scriptProjectNamesCache;
        }
        return this.scriptProjectNamesCache;
    }

    public synchronized void resetOldScriptProjectNames() {
        this.scriptProjectNamesCache = null;
    }

    private File getTimeStampsFile() {
        return DLTKCore.getDefault().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    private File getCustomTimeStampsFile() {
        return DLTKCore.getDefault().getStateLocation().append("customTimeStamps").toFile();
    }

    public void saveExternalLibTimeStamps() throws CoreException {
        if (this.externalTimeStamps != null) {
            this.externalTimeStamps.save();
        }
        if (this.customTimeStamps != null) {
            this.customTimeStamps.save();
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        HashMap otherUpdatedRoots;
        HashMap updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        for (IPath path : updatedRoots.keySet()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            if (!containerPath.isPrefixOf(path) || containerPath.equals((Object)path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            DeltaProcessor.RootInfo rootInfo2 = (DeltaProcessor.RootInfo)updatedRoots.get(path);
            if (!rootInfo2.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
            if ((rootList = (ArrayList)otherUpdatedRoots.get(path)) == null) continue;
            for (DeltaProcessor.RootInfo rootInfo2 : rootList) {
                if (rootInfo2.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
        }
    }

    public void updateProjectReferences(ScriptProject project, IBuildpathEntry[] oldResolvedPath, boolean canChangeResources) throws ModelException {
        if (canChangeResources) {
            new ProjectReferenceChange(project, oldResolvedPath).updateProjectReferencesIfNecessary();
        } else {
            this.addProjectReferenceChange(project, oldResolvedPath);
        }
    }
}

