/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.List;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DebuggersRegistry {
    public static DebuggerInfo getDefaultDebugger() {
        URL netcoredbgUrl = FileLocator.find((Bundle)AcutePlugin.getDefault().getBundle(), (IPath)new Path("netcoredbg"));
        if (netcoredbgUrl != null) {
            try {
                netcoredbgUrl = FileLocator.toFileURL((URL)netcoredbgUrl);
                File dbgDir = new File(netcoredbgUrl.toURI().normalize()).getAbsoluteFile();
                if (!dbgDir.canExecute() && dbgDir.canExecute()) {
                    Files.setPosixFilePermissions(dbgDir.toPath(), Collections.singleton(PosixFilePermission.OWNER_EXECUTE));
                }
                return new DebuggerInfo(new File(dbgDir, "win32".equals(Platform.getOS()) ? "netcoredbg.exe" : "netcoredbg"), Collections.singletonList("--interpreter=vscode"));
            }
            catch (IOException | URISyntaxException ex) {
                AcutePlugin.logError(ex);
            }
        }
        return new DebuggerInfo(new File("/home/mistria/apps/netcoredbg-linux-master/netcoredbg/netcoredbg"), Collections.singletonList("--interpreter=vscode"));
    }

    public static class DebuggerInfo {
        public final File debugger;
        public final List<String> args;

        private DebuggerInfo(File debugger, List<String> args) {
            this.debugger = debugger;
            this.args = args;
        }
    }
}

