/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.fields;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractInputField
implements ModifyListener {
    private ModifyListener listener;
    private String labelText;
    protected Label label;
    public static final Color ERROR_COLOR = Display.getCurrent().getSystemColor(3);
    public static final Color NORMAL_COLOR = null;

    public AbstractInputField(String string) {
        this.labelText = string;
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this.listener = modifyListener;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.listener != null) {
            this.listener.modifyText(modifyEvent);
        }
    }

    public final String getLabelText() {
        return this.labelText;
    }

    public void createLabelAndControl(Composite composite) {
        this.label = new Label(composite, 0);
        this.label.setText(String.valueOf(this.labelText) + ":");
        this.createControl(composite);
    }

    public boolean validate() {
        boolean bl = this.validateControl();
        if (this.label != null) {
            if (bl) {
                this.label.setForeground(NORMAL_COLOR);
                this.label.setText(String.valueOf(this.labelText) + ":");
            } else {
                this.label.setForeground(ERROR_COLOR);
                this.label.setText("*" + this.labelText + ":");
            }
            this.label.getParent().layout();
        }
        return bl;
    }

    public boolean update() {
        return true;
    }

    protected boolean validateControl() {
        return true;
    }

    protected abstract void createControl(Composite var1);
}

