/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.html.statistics;

import java.net.URL;
import java.util.Vector;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.html.statistics.IPageStatisticsTag;
import org.eclipse.actf.visualization.eval.html.statistics.StatisticsDataFormatException;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.internal.eval.XMLStringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLImageElement;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageStatData
implements IPageStatisticsTag {
    public static final String ISMAP = "ismap";
    public static final String USEMAP = "usemap";
    public static final String LONGDESC = "longdesc";
    protected String altS = "";
    protected Element ancestorLink = null;
    protected String destUrlS = "";
    protected boolean hasAlt = false;
    protected boolean hasHeight = false;
    protected boolean hasLongDesc = false;
    protected boolean hasUseMap = false;
    protected boolean hasWidth = false;
    protected String heightS = "";
    protected boolean isInLink = false;
    protected boolean isMap = false;
    protected String longDescS = "";
    protected Vector<IProblemItem> problemV = new Vector();
    protected String srcS = "";
    protected String urlS = "";
    protected String useMapS = "";
    protected String widthS = "";

    protected ImageStatData() {
    }

    public ImageStatData(HTMLImageElement hTMLImageElement, URL uRL) {
        HTMLAnchorElement hTMLAnchorElement;
        Node node;
        this.urlS = this.srcS = hTMLImageElement.getSrc();
        try {
            this.urlS = new URL(uRL, this.urlS).toString();
        }
        catch (Exception exception) {}
        this.hasAlt = hTMLImageElement.hasAttribute("alt");
        if (this.hasAlt) {
            this.altS = hTMLImageElement.getAlt();
        }
        if (this.hasLongDesc = hTMLImageElement.hasAttribute(LONGDESC)) {
            this.longDescS = hTMLImageElement.getLongDesc();
        }
        if (this.hasUseMap = hTMLImageElement.hasAttribute(USEMAP)) {
            this.useMapS = hTMLImageElement.getUseMap();
        }
        if (this.hasWidth = hTMLImageElement.hasAttribute("width")) {
            this.widthS = hTMLImageElement.getWidth();
        }
        if (this.hasHeight = hTMLImageElement.hasAttribute("height")) {
            this.heightS = hTMLImageElement.getHeight();
        }
        this.isMap = hTMLImageElement.getIsMap();
        if (HtmlTagUtil.hasAncestor(hTMLImageElement, "a") && (node = HtmlTagUtil.getAncestor(hTMLImageElement, "a")) != null && (this.isInLink = (hTMLAnchorElement = (HTMLAnchorElement)node).hasAttribute("href"))) {
            this.destUrlS = hTMLAnchorElement.getHref();
            this.ancestorLink = hTMLAnchorElement;
            try {
                this.destUrlS = new URL(uRL, this.destUrlS).toString();
            }
            catch (Exception exception) {}
        }
    }

    public void addProblemItem(Attributes attributes) throws StatisticsDataFormatException {
        ProblemItemImpl problemItemImpl;
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("targetStr");
        if (string != null && !(problemItemImpl = new ProblemItemImpl(string)).getId().equals("unknown")) {
            if (string2 != null) {
                problemItemImpl.setTargetStringForExport(string2);
            }
            this.addProblemItem(problemItemImpl);
            return;
        }
        throw new StatisticsDataFormatException();
    }

    public void addProblemItem(IProblemItem iProblemItem) {
        this.problemV.add(iProblemItem);
    }

    public String getAlt() {
        return this.altS;
    }

    public Element getAncestorLink() {
        return this.ancestorLink;
    }

    private String getAttr(String string, boolean bl) {
        return this.getAttr(string, Boolean.toString(bl));
    }

    private String getAttr(String string, String string2) {
        return String.valueOf(string) + "=\"" + XMLStringUtil.canonicalize(string2) + "\" ";
    }

    public String getDestUrl() {
        return this.destUrlS;
    }

    public String getHeight() {
        return this.heightS;
    }

    public String getItemXML() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<image " + this.getAttr("src", this.srcS) + this.getAttr("url", this.urlS) + this.getAttr(ISMAP, this.isMap));
        if (this.hasAlt) {
            stringBuffer.append(this.getAttr("alt", this.altS));
        }
        if (this.hasWidth) {
            stringBuffer.append(this.getAttr("width", this.widthS));
        }
        if (this.hasHeight) {
            stringBuffer.append(this.getAttr("height", this.heightS));
        }
        if (this.isInLink) {
            stringBuffer.append(this.getAttr("dest", this.destUrlS));
        }
        if (this.hasLongDesc) {
            stringBuffer.append(this.getAttr(LONGDESC, this.longDescS));
        }
        if (this.hasUseMap) {
            stringBuffer.append(this.getAttr(USEMAP, this.useMapS));
        }
        if ((n = this.problemV.size()) == 0) {
            stringBuffer.append(" />");
        } else {
            stringBuffer.append(" >" + FileUtils.LINE_SEP);
            int n2 = 0;
            while (n2 < n) {
                IProblemItem iProblemItem = this.problemV.get(n2);
                stringBuffer.append("<error " + this.getAttr("id", iProblemItem.getId()) + this.getAttr("targetStr", iProblemItem.getTargetStringForExport()) + " />" + FileUtils.LINE_SEP);
                ++n2;
            }
            stringBuffer.append("</image>");
        }
        return stringBuffer.toString();
    }

    public String getLongDesc() {
        return this.longDescS;
    }

    public Vector<IProblemItem> getProblemV() {
        return this.problemV;
    }

    public String getSrc() {
        return this.srcS;
    }

    public String getUrl() {
        return this.urlS;
    }

    public String getUseMap() {
        return this.useMapS;
    }

    public String getWidth() {
        return this.widthS;
    }

    public boolean isHasAlt() {
        return this.hasAlt;
    }

    public boolean isHasHeight() {
        return this.hasHeight;
    }

    public boolean isHasLongDesc() {
        return this.hasLongDesc;
    }

    public boolean isHasUseMap() {
        return this.hasUseMap;
    }

    public boolean isHasWidth() {
        return this.hasWidth;
    }

    public boolean isInLink() {
        return this.isInLink;
    }

    public boolean isMap() {
        return this.isMap;
    }
}

