/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfValue;

public class Values
implements GraphPattern {
    Variable[] variables;
    RdfValue[][] solutionSequence;
    private static final RdfValue UNDEF = new RdfValue(){

        @Override
        public String getQueryString() {
            return "UNDEF";
        }
    };

    public Values(Variable[] variables, RdfValue[][] solutionSequence) {
        Objects.requireNonNull(solutionSequence);
        Objects.requireNonNull(solutionSequence);
        if (variables.length == 0) {
            throw new IllegalArgumentException("no variables provided for VALUES clause");
        }
        if (solutionSequence.length == 0 || solutionSequence[0] == null || solutionSequence[0].length == 0) {
            throw new IllegalArgumentException("no values provided for VALUES clause");
        }
        if (solutionSequence[0].length != variables.length) {
            throw new IllegalArgumentException(solutionSequence[0].length + " values provided  for " + variables.length + String.valueOf(variables));
        }
        this.solutionSequence = solutionSequence;
        this.variables = variables;
    }

    @Override
    public String getQueryString() {
        int i;
        StringBuilder sb = new StringBuilder();
        String parOpen = this.variables.length > 1 ? "( " : "";
        String parClose = this.variables.length > 1 ? ") " : "";
        sb.append("VALUES ").append(parOpen);
        for (i = 0; i < this.variables.length; ++i) {
            sb.append(this.variables[i].getQueryString()).append(" ");
        }
        sb.append(parClose).append("{").append(System.lineSeparator());
        for (i = 0; i < this.solutionSequence.length; ++i) {
            sb.append("  ").append(parOpen);
            for (int j = 0; j < this.solutionSequence[i].length; ++j) {
                sb.append(this.solutionSequence[i][j].getQueryString()).append(" ");
            }
            sb.append(parClose).append(System.lineSeparator());
        }
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public static VariablesBuilder builder() {
        return new Builder();
    }

    private static RdfValue valueOrUndef(RdfValue value) {
        if (value == null) {
            return UNDEF;
        }
        return value;
    }

    public static class Builder
    implements VariablesBuilder,
    ValuesBuilder {
        private List<Variable> variables = new ArrayList<Variable>();
        private List<List<RdfValue>> values = new ArrayList<List<RdfValue>>();
        private List<RdfValue> currentValues = new ArrayList<RdfValue>();

        @Override
        public VariablesBuilder variables(Variable ... variable) {
            Arrays.stream(variable).forEach(this.variables::add);
            return this;
        }

        @Override
        public ValuesBuilder value(RdfValue value) {
            this.currentValues.add(Values.valueOrUndef(value));
            if (this.currentValues.size() >= this.variables.size()) {
                this.values.add(this.currentValues);
                this.currentValues = new ArrayList<RdfValue>();
            }
            return this;
        }

        @Override
        public ValuesBuilder values(RdfValue ... values) {
            if (this.variables.size() == 1) {
                for (int i = 0; i < values.length; ++i) {
                    this.values.add(List.of(Values.valueOrUndef(values[i])));
                }
            } else if (this.variables.size() == values.length) {
                this.values.add(Stream.of(values).map(x$0 -> Values.valueOrUndef(x$0)).collect(Collectors.toList()));
            } else {
                throw new IllegalArgumentException("Provided list of values must match length of variables, or there must be only one variable.");
            }
            return this;
        }

        @Override
        public ValuesBuilder values(Collection<RdfValue> values) {
            return this.values((RdfValue[])values.toArray(RdfValue[]::new));
        }

        @Override
        public ValuesBuilder iriValue(IRI value) {
            return this.value(Rdf.iri(value));
        }

        @Override
        public ValuesBuilder iriValues(IRI ... values) {
            return this.values((RdfValue[])Stream.of(values).map(Rdf::iri).toArray(RdfValue[]::new));
        }

        @Override
        public ValuesBuilder iriValues(Collection<IRI> values) {
            return this.iriValues((IRI[])values.toArray(IRI[]::new));
        }

        @Override
        public Values build() {
            if (this.values.isEmpty()) {
                throw new IllegalArgumentException("No values provided");
            }
            if (!this.currentValues.isEmpty()) {
                throw new IllegalArgumentException("Current solution sequence is not finished - you added too few or too many values.");
            }
            RdfValue[][] values = new RdfValue[this.values.size()][this.variables.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                List<RdfValue> current = this.values.get(i);
                if (current.size() != this.variables.size()) {
                    throw new IllegalArgumentException(String.format("You provided $d values for $d variables", current.size(), this.variables.size()));
                }
                for (int j = 0; j < current.size(); ++j) {
                    values[i][j] = current.get(j);
                }
            }
            return new Values((Variable[])this.variables.toArray(Variable[]::new), values);
        }
    }

    public static interface ValuesBuilder {
        public ValuesBuilder value(RdfValue var1);

        public ValuesBuilder values(RdfValue ... var1);

        public ValuesBuilder values(Collection<RdfValue> var1);

        public ValuesBuilder iriValue(IRI var1);

        public ValuesBuilder iriValues(IRI ... var1);

        public ValuesBuilder iriValues(Collection<IRI> var1);

        public Values build();
    }

    public static interface VariablesBuilder {
        public VariablesBuilder variables(Variable ... var1);

        public ValuesBuilder value(RdfValue var1);

        public ValuesBuilder values(RdfValue ... var1);

        public ValuesBuilder values(Collection<RdfValue> var1);

        public ValuesBuilder iriValue(IRI var1);

        public ValuesBuilder iriValues(IRI ... var1);

        public ValuesBuilder iriValues(Collection<IRI> var1);
    }
}

