/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class NumericLiteral
extends AbstractLiteral {
    private static final long serialVersionUID = 3004497457768807919L;
    private final Number number;
    private final CoreDatatype datatype;

    protected NumericLiteral(Number number, IRI datatype) {
        assert (Objects.nonNull(number));
        assert (Objects.nonNull(datatype));
        this.datatype = CoreDatatype.from(datatype);
        this.number = number;
    }

    protected NumericLiteral(Number number, CoreDatatype datatype) {
        this.datatype = datatype;
        this.number = number;
    }

    protected NumericLiteral(byte number) {
        this((Number)number, CoreDatatype.XSD.BYTE);
    }

    protected NumericLiteral(short number) {
        this((Number)number, CoreDatatype.XSD.SHORT);
    }

    protected NumericLiteral(int number) {
        this((Number)number, CoreDatatype.XSD.INT);
    }

    protected NumericLiteral(long n) {
        this((Number)n, CoreDatatype.XSD.LONG);
    }

    protected NumericLiteral(float n) {
        this((Number)Float.valueOf(n), CoreDatatype.XSD.FLOAT);
    }

    protected NumericLiteral(double n) {
        this((Number)n, CoreDatatype.XSD.DOUBLE);
    }

    @Override
    public byte byteValue() {
        return this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number.shortValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public String getLabel() {
        return XMLDatatypeUtil.toString(this.number);
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.empty();
    }

    @Override
    public IRI getDatatype() {
        return this.datatype.getIri();
    }

    @Override
    public CoreDatatype getCoreDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NumericLiteral) {
            return this.datatype == ((NumericLiteral)o).datatype && this.number.equals(((NumericLiteral)o).number);
        }
        return super.equals(o);
    }
}

