/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.endpoint.EndpointConfiguration;
import org.eclipse.rdf4j.federated.endpoint.ManagedRepositoryEndpoint;
import org.eclipse.rdf4j.federated.endpoint.SparqlEndpointConfiguration;
import org.eclipse.rdf4j.federated.endpoint.provider.EndpointProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.SPARQLRepositoryInformation;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;

public class SPARQLProvider
implements EndpointProvider<SPARQLRepositoryInformation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint loadEndpoint(SPARQLRepositoryInformation repoInfo) throws FedXException {
        try {
            SPARQLRepository repo = new SPARQLRepository(repoInfo.getLocation());
            HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties().setMaxConnTotal(20).setMaxConnPerRoute(20);
            ((SharedHttpClientSessionManager)repo.getHttpClientSessionManager()).setHttpClientBuilder(httpClientBuilder);
            try {
                repo.init();
            }
            finally {
                repo.shutDown();
            }
            String location = repoInfo.getLocation();
            EndpointClassification epc = EndpointClassification.Remote;
            ManagedRepositoryEndpoint res = new ManagedRepositoryEndpoint(repoInfo, location, epc, (Repository)repo);
            EndpointConfiguration ep = this.manipulateEndpointConfiguration(location, repoInfo.getEndpointConfiguration());
            res.setEndpointConfiguration(ep);
            return res;
        }
        catch (RepositoryException e) {
            throw new FedXException("Repository " + repoInfo.getId() + " could not be initialized: " + e.getMessage(), e);
        }
    }

    private EndpointConfiguration manipulateEndpointConfiguration(String location, EndpointConfiguration ep) {
        if (location.equals("http://dbpedia.org/sparql")) {
            if (ep == null) {
                ep = new SparqlEndpointConfiguration();
            }
            if (ep instanceof SparqlEndpointConfiguration) {
                ((SparqlEndpointConfiguration)ep).setSupportsASKQueries(false);
            }
        }
        return ep;
    }
}

