/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.setting;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.slf4j.LoggerFactory;

public class LogLevel
extends ConsoleSetting<String> {
    public static final String NAME = "log";
    private static final BiMap<String, Level> LOG_LEVELS;

    @Override
    public String getHelpLong() {
        return "set log=<level>                Set the logging level (none, error, warning, info or debug)\n";
    }

    public LogLevel() {
        super("info");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String get() {
        Logger logbackRootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Level currentLevel = logbackRootLogger.getLevel();
        return (String)LOG_LEVELS.inverse().getOrDefault((Object)currentLevel, (Object)currentLevel.levelStr);
    }

    @Override
    public void set(String value) throws IllegalArgumentException {
        Level logLevel = (Level)LOG_LEVELS.get((Object)value.toLowerCase());
        if (logLevel == null) {
            throw new IllegalArgumentException("unknown logging level: " + value);
        }
        Logger logbackRootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logbackRootLogger.setLevel(logLevel);
    }

    @Override
    public void setFromString(String value) throws IllegalArgumentException {
        this.set(value);
    }

    static {
        ImmutableBiMap.Builder logLevels = ImmutableBiMap.builder();
        logLevels.put((Object)"none", (Object)Level.OFF);
        logLevels.put((Object)"error", (Object)Level.ERROR);
        logLevels.put((Object)"warning", (Object)Level.WARN);
        logLevels.put((Object)"info", (Object)Level.INFO);
        logLevels.put((Object)"debug", (Object)Level.DEBUG);
        LOG_LEVELS = logLevels.build();
    }
}

