/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.function.Predicate;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;

public class PostFilterQueryEvaluationStep
implements QueryEvaluationStep {
    private final QueryEvaluationStep wrapped;
    private final Predicate<BindingSet> condition;

    public PostFilterQueryEvaluationStep(QueryEvaluationStep wrapped, QueryValueEvaluationStep condition) {
        this.wrapped = wrapped;
        this.condition = condition.asPredicate();
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet leftBindings) {
        CloseableIteration<BindingSet> rightIteration = this.wrapped.evaluate(leftBindings);
        if (rightIteration == QueryEvaluationStep.EMPTY_ITERATION) {
            return rightIteration;
        }
        return new FilterIteration<BindingSet>(rightIteration){

            protected boolean accept(BindingSet bindings) {
                return PostFilterQueryEvaluationStep.this.condition.test(bindings);
            }

            protected void handleClose() {
            }
        };
    }
}

