/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.io.IOException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.trigstar.TriGStarParser;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class SPARQLUpdateDataBlockParser
extends TriGStarParser {
    private boolean allowBlankNodes = true;
    private int lineNumberOffset;

    public SPARQLUpdateDataBlockParser() {
    }

    public SPARQLUpdateDataBlockParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return null;
    }

    @Override
    protected void parseGraph() throws RDFParseException, RDFHandlerException, IOException {
        int c = this.readCodePoint();
        int c2 = this.peekCodePoint();
        Resource contextOrSubject = null;
        boolean foundContextOrSubject = false;
        if (c == 91) {
            this.skipWSC();
            c2 = this.readCodePoint();
            if (c2 == 93) {
                contextOrSubject = this.createNode();
                foundContextOrSubject = true;
                this.skipWSC();
            } else {
                this.unread(c2);
                this.unread(c);
            }
            c = this.readCodePoint();
        } else if (c == 60 || TurtleUtil.isPrefixStartChar(c) || c == 58 && c2 != 45 || c == 95 && c2 == 58) {
            this.unread(c);
            Value value = this.parseValue();
            if (value instanceof Resource) {
                contextOrSubject = (Resource)value;
                foundContextOrSubject = true;
            } else {
                this.reportFatalError("Illegal graph name: " + String.valueOf(value));
            }
            this.skipWSC();
            c = this.readCodePoint();
        } else {
            this.setContext(null);
        }
        if (c == 123) {
            this.setContext(contextOrSubject);
            c = this.skipWSC();
            if (c != 125) {
                this.parseTriples();
                c = this.skipWSC();
                while (c == 46) {
                    this.readCodePoint();
                    c = this.skipWSC();
                    if (c == 125) break;
                    this.parseTriples();
                    c = this.skipWSC();
                }
                this.verifyCharacterOrFail(c, "}");
            }
        } else {
            this.setContext(null);
            if (foundContextOrSubject) {
                this.subject = contextOrSubject;
                this.unread(c);
                this.parsePredicateObjectList();
            } else {
                this.unread(c);
                this.parseTriples();
            }
        }
        if ((c = this.peekCodePoint()) == 46 || c == 125) {
            this.readCodePoint();
        }
        this.skipOptionalPeriod();
    }

    @Override
    protected Resource parseImplicitBlank() throws IOException, RDFParseException, RDFHandlerException {
        if (this.isAllowBlankNodes()) {
            return super.parseImplicitBlank();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    @Override
    protected Resource parseNodeID() throws IOException, RDFParseException {
        if (this.isAllowBlankNodes()) {
            return super.parseNodeID();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    public boolean isAllowBlankNodes() {
        return this.allowBlankNodes;
    }

    public void setAllowBlankNodes(boolean allowBlankNodes) {
        this.allowBlankNodes = allowBlankNodes;
    }

    @Override
    protected int getLineNumber() {
        return super.getLineNumber() - this.lineNumberOffset;
    }

    private void skipOptionalPeriod() throws RDFHandlerException, IOException {
        this.skipWSC();
        int c = this.peekCodePoint();
        if (c == 46) {
            this.readCodePoint();
        }
    }

    public void setLineNumberOffset(int lineNumberOffset) {
        this.lineNumberOffset = lineNumberOffset;
    }
}

