/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

@Experimental
public class AsyncIteratorReadAhead
extends LookAheadIteration<BindingSet> {
    private final int READ_AHEAD_LIMIT = 0x1000000;
    private final ExecutorService executorService;
    private int readAhead = 4;
    private final CloseableIteration<BindingSet> iteration;
    private Future<ArrayDeque<BindingSet>> future;
    ArrayDeque<BindingSet> nextBuffer;
    BindingSet next;

    public AsyncIteratorReadAhead(CloseableIteration<BindingSet> iteration) throws QueryEvaluationException {
        this.iteration = iteration;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep iterationPrepared, BindingSet bindings, QueryEvaluationContext context) {
        CloseableIteration<BindingSet> iter = iterationPrepared.evaluate(bindings);
        if (iter == QueryEvaluationStep.EMPTY_ITERATION) {
            return iter;
        }
        return new AsyncIteratorReadAhead(iter);
    }

    void calculateNext() {
        if (this.next != null) {
            return;
        }
        if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
            this.next = this.nextBuffer.removeFirst();
            return;
        }
        try {
            this.nextBuffer = this.async();
            if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
                this.next = this.nextBuffer.removeFirst();
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ArrayDeque<BindingSet> async() throws ExecutionException, InterruptedException {
        ArrayDeque<Object> buffer;
        ArrayDeque<BindingSet> ret = null;
        if (this.future != null) {
            ret = this.future.get();
            this.future = null;
        } else if (this.iteration.hasNext()) {
            ret = new ArrayDeque(1);
            ret.add((BindingSet)this.iteration.next());
        } else {
            return null;
        }
        if (this.readAhead < 0x1000000) {
            this.readAhead *= 2;
        }
        if (this.nextBuffer != null) {
            this.nextBuffer.clear();
            buffer = this.nextBuffer;
        } else {
            buffer = new ArrayDeque();
        }
        this.future = this.executorService.submit(() -> {
            int currentReadAhead = this.readAhead;
            for (int i = 0; i < currentReadAhead && this.iteration.hasNext(); ++i) {
                buffer.addLast((BindingSet)this.iteration.next());
            }
            if (buffer.isEmpty()) {
                return null;
            }
            return buffer;
        });
        return ret;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        this.calculateNext();
        BindingSet temp = this.next;
        this.next = null;
        return temp;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
        finally {
            try {
                this.executorService.shutdownNow();
            }
            finally {
                this.iteration.close();
            }
        }
    }
}

