/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;

public class ParallelServiceJoinTask
extends ParallelTaskBase<BindingSet> {
    protected final FederationEvalStrategy strategy;
    protected final FedXService expr;
    protected final List<BindingSet> bindings;
    protected final ParallelExecutor<BindingSet> joinControl;

    public ParallelServiceJoinTask(ParallelExecutor<BindingSet> joinControl, FederationEvalStrategy strategy, FedXService expr, List<BindingSet> bindings) {
        this.strategy = strategy;
        this.expr = expr;
        this.bindings = bindings;
        this.joinControl = joinControl;
    }

    @Override
    protected CloseableIteration<BindingSet> performTaskInternal() throws Exception {
        try (CloseableIteration<BindingSet> iter = this.strategy.evaluateService(this.expr, this.bindings);){
            CollectionIteration<BindingSet> collectionIteration = new CollectionIteration<BindingSet>(Iterations.asList(iter));
            return collectionIteration;
        }
    }

    @Override
    public ParallelExecutor<BindingSet> getControl() {
        return this.joinControl;
    }
}

