/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.BoundJoinTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.evaluation.join.JoinExecutorBase;
import org.eclipse.rdf4j.federated.evaluation.join.PhaserHandlingParallelExecutor;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlledWorkerBindJoinBase
extends JoinExecutorBase<BindingSet> {
    private static final Logger log = LoggerFactory.getLogger(ControlledWorkerBindJoinBase.class);
    protected final ControlledWorkerScheduler<BindingSet> scheduler;
    protected final Phaser phaser = new Phaser(1);

    public ControlledWorkerBindJoinBase(ControlledWorkerScheduler<BindingSet> scheduler, FederationEvalStrategy strategy, CloseableIteration<BindingSet> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, rightArg, bindings, queryInfo);
        this.scheduler = scheduler;
    }

    @Override
    protected void handleBindings() throws Exception {
        if (!(this.rightArg instanceof BoundJoinTupleExpr)) {
            String msg = "Right argument is not an applicable expression for bind joins. Was: " + this.rightArg.getClass().getCanonicalName();
            log.debug(msg);
            throw new QueryEvaluationException(msg);
        }
        int nBindingsCfg = this.queryInfo.getFederationContext().getConfig().getBoundJoinBlockSize();
        int totalBindings = 0;
        TupleExpr expr = this.rightArg;
        TaskCreator taskCreator = null;
        Phaser currentPhaser = this.phaser;
        while (!this.isClosed() && this.leftIter.hasNext()) {
            int count;
            if (currentPhaser.getRegisteredParties() >= 10000) {
                currentPhaser = new Phaser(currentPhaser);
            }
            int nBindings = this.getNextBindJoinSize(nBindingsCfg, totalBindings);
            ArrayList<BindingSet> bindings = new ArrayList<BindingSet>(nBindings);
            for (count = 0; !this.isClosed() && count < nBindings && this.leftIter.hasNext(); ++count) {
                BindingSet bs = (BindingSet)this.leftIter.next();
                if (taskCreator == null) {
                    taskCreator = this.determineTaskCreator(expr, bs);
                }
                bindings.add(bs);
            }
            totalBindings += count;
            currentPhaser.register();
            this.scheduler.schedule(taskCreator.getTask(new PhaserHandlingParallelExecutor(this, currentPhaser), bindings));
        }
        this.leftIter.close();
        this.scheduler.informFinish(this);
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindings + " results.");
        }
        this.phaser.awaitAdvanceInterruptibly(this.phaser.arrive(), this.queryInfo.getMaxRemainingTimeMS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.phaser.forceTermination();
        }
    }

    protected abstract TaskCreator determineTaskCreator(TupleExpr var1, BindingSet var2);

    protected int getNextBindJoinSize(int configuredBindJoinSize, int totalBindings) {
        return configuredBindJoinSize;
    }

    protected static interface TaskCreator {
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> var1, List<BindingSet> var2);
    }
}

