/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import org.eclipse.core.runtime.Assert;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;

public class GenericElementKind {
    public final ElementKind kind;
    public final String customKindId;
    public static final GenericElementKind Unknown = new GenericElementKind(ElementKind.Unknown);

    public GenericElementKind(ElementKind kind) {
        Assert.isNotNull((Object)((Object)kind));
        this.kind = kind;
        this.customKindId = null;
    }

    public GenericElementKind(String customKindId) {
        this.kind = ElementKind.Custom;
        this.customKindId = customKindId;
    }

    public boolean equals(Object kind) {
        if (kind instanceof ElementKind) {
            return this.is(kind);
        }
        return super.equals(kind);
    }

    public boolean is(ElementKind kind) {
        if (kind == null) {
            return false;
        }
        return this.kind == kind;
    }

    public boolean is(String customKindId) {
        if (customKindId == null) {
            return false;
        }
        return customKindId.equals(this.customKindId);
    }

    public boolean is(GenericElementKind gk) {
        if (gk.kind == ElementKind.Custom) {
            return this.kind == ElementKind.Custom && this.is(gk.customKindId);
        }
        return this.is(gk.kind);
    }

    public boolean is(Object kind) {
        if (kind instanceof GenericElementKind) {
            return this.is((GenericElementKind)kind);
        }
        if (kind instanceof ElementKind) {
            return this.is((ElementKind)((Object)kind));
        }
        if (kind instanceof String) {
            return this.is((String)kind);
        }
        return false;
    }

    public boolean in(Object ... kinds) {
        Object[] objectArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            Object kind = objectArray[n2];
            if (this.is(kind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String name() {
        if (this.kind == ElementKind.Custom) {
            return this.customKindId;
        }
        return this.kind.name();
    }

    public String toString() {
        return this.name();
    }

    public boolean isLabel() {
        return this.kind == ElementKind.Label || this.kind == ElementKind.Link;
    }

    public boolean skipFirstAfter() {
        return this.kind != ElementKind.Text && this.kind != ElementKind.Combo;
    }

    public static GenericElementKind fromString(String kindName) {
        if (kindName == null) {
            return null;
        }
        ElementKind kind = ElementKind.kindOf(kindName);
        return kind == ElementKind.Custom ? new GenericElementKind(kindName) : new GenericElementKind(kind);
    }
}

