/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.recording;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.rcptt.core.recording.CommandInfo;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.raw.AssertionFocus;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.Widget;

public class CommandSet {
    private CommandInfo[] commands;
    private Element element;
    private Widget widget;
    private byte[] imageCapture;

    private CommandSet(Element element, Widget widget, CommandInfo[] commands) {
        this.element = element;
        this.widget = widget;
        this.commands = commands;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public Element getElement() {
        return this.element;
    }

    public CommandInfo[] getCommands() {
        return this.commands;
    }

    public void setImageCapture(byte[] imageCapture) {
        this.imageCapture = imageCapture;
    }

    public byte[] getImageCapture() {
        return this.imageCapture;
    }

    public static CommandSet create(AssertionFocus focusCommand, TeslaScenarioContainer container) throws IllegalArgumentException {
        Element element = focusCommand.getElement();
        if (element == null) {
            throw new IllegalArgumentException("Internal error: selected control haven't element");
        }
        Command cmd = CommandSet.getCommand(element, container);
        if (cmd == null) {
            throw new IllegalArgumentException("Internal error: can't find a command which produce selected element");
        }
        Widget widget = CommandSet.findWidget(cmd, container);
        if (widget == null) {
            throw new IllegalArgumentException("Internal error: can't find widget for selected element");
        }
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        CommandSet.collectElements(commands, cmd, container);
        final List originalCommands = container.getCommands();
        Collections.sort(commands, new Comparator<CommandInfo>(){

            @Override
            public int compare(CommandInfo o1, CommandInfo o2) {
                int i2;
                int i1 = originalCommands.indexOf(o1.getCommand());
                if (i1 < (i2 = originalCommands.indexOf(o2.getCommand()))) {
                    return 1;
                }
                return -1;
            }
        });
        int size = commands.size();
        CommandInfo[] resultCommands = new CommandInfo[size];
        int i = 0;
        while (i < resultCommands.length) {
            resultCommands[i] = (CommandInfo)commands.get(size - i - 1);
            ++i;
        }
        CommandSet cmdSet = new CommandSet(element, widget, resultCommands);
        cmdSet.setImageCapture(focusCommand.getImageCapture());
        return cmdSet;
    }

    private static void collectElements(List<CommandInfo> commands, Command cmd, TeslaScenarioContainer container) {
        for (CommandInfo commandInfo : commands) {
            if (commandInfo.getCommand() != cmd) continue;
            return;
        }
        CommandInfo info = new CommandInfo(cmd, container.getElements(cmd), container.getControls(cmd));
        commands.add(info);
        if (cmd instanceof SelectCommand) {
            Element element;
            Command newCommand;
            SelectCommand sc = (SelectCommand)cmd;
            Element after = sc.getData().getAfter();
            Command afterCommand = CommandSet.getCommand(after, container);
            if (afterCommand != null) {
                CommandSet.collectElements(commands, afterCommand, container);
            }
            if ((newCommand = CommandSet.getCommand(element = sc.getData().getParent(), container)) != null) {
                CommandSet.collectElements(commands, newCommand, container);
            }
        }
    }

    private static Command getCommand(Element element, TeslaScenarioContainer container) {
        if (element == null || element.getId() == null) {
            return null;
        }
        List commands = container.getCommands();
        int i = commands.size() - 1;
        while (i >= 0) {
            Command cmd = (Command)commands.get(i);
            List elements = container.getElements(cmd);
            if (elements != null) {
                for (Element elementToCheck : elements) {
                    if (!element.getId().equals(elementToCheck.getId())) continue;
                    return cmd;
                }
            }
            --i;
        }
        return null;
    }

    private static Widget findWidget(Command cmd, TeslaScenarioContainer container) {
        List controls = container.getControls(cmd);
        if (controls != null && controls.size() > 0) {
            return (Widget)controls.get(0);
        }
        return null;
    }
}

