/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.util.SimpleWordSet;

public class MemoryIndex {
    public int NUM_CHANGES = 100;
    SimpleLookupTable docsToReferences = new SimpleLookupTable(7);
    SimpleWordSet allWords = new SimpleWordSet(7);
    String lastDocumentName;
    HashtableOfObject lastReferenceTable;

    MemoryIndex() {
    }

    void addDocumentNames(String substring, SimpleSet results) {
        Object[] paths = this.docsToReferences.keyTable;
        Object[] referenceTables = this.docsToReferences.valueTable;
        if (substring == null) {
            int i = 0;
            int l = referenceTables.length;
            while (i < l) {
                if (referenceTables[i] != null) {
                    results.add(paths[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            int l = referenceTables.length;
            while (i < l) {
                if (referenceTables[i] != null && ((String)paths[i]).startsWith(substring, 0)) {
                    results.add(paths[i]);
                }
                ++i;
            }
        }
    }

    void addIndexEntry(char[] category, char[] key, String documentName) {
        HashtableOfObject referenceTable;
        if (documentName.equals(this.lastDocumentName)) {
            referenceTable = this.lastReferenceTable;
        } else {
            referenceTable = (HashtableOfObject)this.docsToReferences.get((Object)documentName);
            if (referenceTable == null) {
                referenceTable = new HashtableOfObject(3);
                this.docsToReferences.put((Object)documentName, (Object)referenceTable);
            }
            this.lastDocumentName = documentName;
            this.lastReferenceTable = referenceTable;
        }
        SimpleWordSet existingWords = (SimpleWordSet)referenceTable.get(category);
        if (existingWords == null) {
            existingWords = new SimpleWordSet(1);
            referenceTable.put(category, (Object)existingWords);
        }
        existingWords.add(this.allWords.add(key));
    }

    HashtableOfObject addQueryResults(char[][] categories, char[] key, int matchRule, HashtableOfObject results) {
        Object[] paths = this.docsToReferences.keyTable;
        Object[] referenceTables = this.docsToReferences.valueTable;
        if (matchRule == 8 && key != null) {
            int i = 0;
            int l = referenceTables.length;
            while (i < l) {
                HashtableOfObject categoryToWords = (HashtableOfObject)referenceTables[i];
                if (categoryToWords != null) {
                    char[][] cArray = categories;
                    int n = categories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] category = cArray[n2];
                        SimpleWordSet wordSet = (SimpleWordSet)categoryToWords.get(category);
                        if (wordSet != null && wordSet.includes(key)) {
                            EntryResult result;
                            if (results == null) {
                                results = new HashtableOfObject(13);
                            }
                            if ((result = (EntryResult)results.get(key)) == null) {
                                result = new EntryResult(key, null);
                                results.put(key, (Object)result);
                            }
                            result.addDocumentName((String)paths[i]);
                            break;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int l = referenceTables.length;
            while (i < l) {
                HashtableOfObject categoryToWords = (HashtableOfObject)referenceTables[i];
                if (categoryToWords != null) {
                    char[][] cArray = categories;
                    int n = categories.length;
                    int n3 = 0;
                    while (n3 < n) {
                        char[] category = cArray[n3];
                        SimpleWordSet wordSet = (SimpleWordSet)categoryToWords.get(category);
                        if (wordSet != null) {
                            char[][] words;
                            char[][] cArray2 = words = wordSet.words;
                            int n4 = words.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                char[] word = cArray2[n5];
                                if (word != null && Index.isMatch(key, word, matchRule)) {
                                    EntryResult result;
                                    if (results == null) {
                                        results = new HashtableOfObject(13);
                                    }
                                    if ((result = (EntryResult)results.get(word)) == null) {
                                        result = new EntryResult(word, null);
                                        results.put(word, (Object)result);
                                    }
                                    result.addDocumentName((String)paths[i]);
                                }
                                ++n5;
                            }
                        }
                        ++n3;
                    }
                }
                ++i;
            }
        }
        return results;
    }

    boolean hasChanged() {
        return this.docsToReferences.elementSize > 0;
    }

    void remove(String documentName) {
        if (documentName.equals(this.lastDocumentName)) {
            this.lastDocumentName = null;
            this.lastReferenceTable = null;
        }
        this.docsToReferences.put((Object)documentName, null);
    }

    boolean shouldMerge() {
        return this.docsToReferences.elementSize >= this.NUM_CHANGES;
    }
}

